/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.network.client.CPSyncRewardsData;
import austeretony.oxygen_dailyrewards.common.reward.EnumReward;
import austeretony.oxygen_dailyrewards.common.reward.Reward;
import austeretony.oxygen_dailyrewards.server.DailyRewardsManagerServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RewardsDataContainerServer {
    private final DailyRewardsManagerServer manager;
    private final List<Reward> rewards = new ArrayList<Reward>(31);
    private final ByteBuf compressedRewards = Unpooled.buffer();

    public RewardsDataContainerServer(DailyRewardsManagerServer manager) {
        this.manager = manager;
    }

    public void reloadRewards() {
        Runnable reloadingTask = () -> {
            Future future = OxygenHelperServer.addIOTask(this::loadRewardsData);
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            OxygenHelperServer.getOnlinePlayersUUIDs().forEach(playerUUID -> this.syncRewardsData(CommonReference.playerByUUID((UUID)playerUUID)));
            OxygenMain.LOGGER.info("[Daily Rewards] Daily rewards reloaded.");
        };
        OxygenHelperServer.addRoutineTask((Runnable)reloadingTask);
    }

    public void loadRewardsData() {
        String folder = null;
        if (DailyRewardsConfig.REWARD_MODE.asInt() == 0) {
            Month currentMonth = TimeHelperServer.getZonedDateTime().getMonth();
            String monthName = currentMonth.getDisplayName(TextStyle.FULL, Locale.ENGLISH);
            folder = OxygenHelperCommon.getConfigFolder() + "data/server/daily rewards/rewards_" + monthName.toLowerCase() + ".json";
        } else {
            folder = OxygenHelperCommon.getConfigFolder() + "data/server/daily rewards/rewards.json";
        }
        Path path = Paths.get(folder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            RewardsDataContainerServer.createDefaultRewardFiles();
        }
        this.rewards.clear();
        try {
            JsonArray rewardsArray = JsonUtils.getExternalJsonData((String)folder).getAsJsonArray();
            for (JsonElement rewardElement : rewardsArray) {
                JsonObject rewardObject = rewardElement.getAsJsonObject();
                EnumReward enumReward = EnumReward.valueOf(rewardObject.get("type").getAsString());
                this.rewards.add(enumReward.fromJson(rewardObject));
            }
            OxygenMain.LOGGER.info("[Daily Rewards] Successfuly loaded rewards from file <{}>.", (Object)folder);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Daily Rewards] Rewards data file <" + folder + "> is damaged!", (Throwable)exception);
            exception.printStackTrace();
        }
        this.compressRewardsData();
    }

    private static void createDefaultRewardFiles() {
        JsonObject defaultReward = ItemStackWrapper.of((ItemStack)new ItemStack(Items.field_151166_bC)).toJson().getAsJsonObject();
        if (DailyRewardsConfig.REWARD_MODE.asInt() == 0) {
            for (Month month : Month.values()) {
                String folder = OxygenHelperCommon.getConfigFolder() + "data/server/daily rewards/rewards_" + month.getDisplayName(TextStyle.FULL, Locale.ENGLISH).toLowerCase() + ".json";
                RewardsDataContainerServer.createDefaultRewardsFile(folder, month.maxLength());
            }
        } else {
            String folder = OxygenHelperCommon.getConfigFolder() + "data/server/daily rewards/rewards.json";
            RewardsDataContainerServer.createDefaultRewardsFile(folder, 7);
        }
        OxygenMain.LOGGER.info("[Daily Rewards] Successfuly created default daily rewards data file(s).");
    }

    private static void createDefaultRewardsFile(String folder, int days) {
        Path path = Paths.get(folder, new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            JsonArray rewardsArray = new JsonArray();
            JsonObject defaultReward = ItemStackWrapper.of((ItemStack)new ItemStack(Items.field_151166_bC)).toJson().getAsJsonObject();
            for (int i = 0; i < days; ++i) {
                JsonObject rewardObject = new JsonObject();
                rewardObject.add("day", (JsonElement)new JsonPrimitive((Number)(i + 1)));
                rewardObject.add("type", (JsonElement)new JsonPrimitive(EnumReward.ITEM.toString()));
                rewardObject.add("description", (JsonElement)new JsonPrimitive("oxygen_dailyrewards.description.item"));
                rewardObject.add("amount", (JsonElement)new JsonPrimitive((Number)1));
                rewardObject.add("special", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                rewardObject.add("itemstack", (JsonElement)defaultReward);
                rewardsArray.add((JsonElement)rewardObject);
            }
            JsonUtils.createExternalJsonFile((String)folder, (JsonElement)rewardsArray);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Daily Rewards] Failed to create default reward data file! Path: {}", (Object)folder);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressRewardsData() {
        ByteBuf byteBuf = this.compressedRewards;
        synchronized (byteBuf) {
            this.compressedRewards.clear();
            this.compressedRewards.writeByte(this.rewards.size());
            for (Reward reward : this.rewards) {
                this.compressedRewards.writeByte(reward.getType().ordinal());
                reward.write(this.compressedRewards);
            }
        }
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    @Nullable
    public Reward getDailyReward(int day) {
        Reward reward = null;
        try {
            reward = this.rewards.get(day - 1);
        }
        catch (IndexOutOfBoundsException exception) {
            OxygenMain.LOGGER.error("[Daily Rewards] Reward index <{}> out of bounds!", (Object)day);
            exception.printStackTrace();
        }
        return reward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRewardsData(@Nullable EntityPlayerMP playerMP) {
        if (playerMP != null) {
            ByteBuf byteBuf = this.compressedRewards;
            synchronized (byteBuf) {
                byte[] compressed = new byte[this.compressedRewards.writerIndex()];
                this.compressedRewards.getBytes(0, compressed);
                OxygenMain.network().sendTo((Packet)new CPSyncRewardsData(compressed), playerMP);
            }
        }
    }
}

