/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.common.reward;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.InventoryProviderServer;
import austeretony.oxygen_core.server.api.SoundEventHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.reward.EnumReward;
import austeretony.oxygen_dailyrewards.common.reward.Reward;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RewardItem
implements Reward {
    private String description;
    private int day;
    private int amount;
    private boolean special;
    private ItemStackWrapper stackWrapper;

    @Override
    public EnumReward getType() {
        return EnumReward.ITEM;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTooltip() {
        return null;
    }

    @Override
    public boolean isSpecial() {
        return this.special;
    }

    public static Reward fromJson(JsonObject jsonObject) {
        RewardItem reward = new RewardItem();
        reward.day = jsonObject.get("day").getAsInt();
        reward.description = jsonObject.get("description").getAsString();
        reward.amount = jsonObject.get("amount").getAsInt();
        reward.special = jsonObject.get("special").getAsBoolean();
        reward.stackWrapper = ItemStackWrapper.fromJson((JsonObject)jsonObject.get("itemstack").getAsJsonObject());
        return reward;
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeByte(this.day);
        ByteBufUtils.writeString((String)this.description, (ByteBuf)buffer);
        buffer.writeShort(this.amount);
        buffer.writeBoolean(this.special);
        this.stackWrapper.write(buffer);
    }

    public static Reward read(ByteBuf buffer) {
        RewardItem reward = new RewardItem();
        reward.day = buffer.readByte();
        reward.description = ByteBufUtils.readString((ByteBuf)buffer);
        reward.amount = buffer.readShort();
        reward.special = buffer.readBoolean();
        reward.stackWrapper = ItemStackWrapper.read((ByteBuf)buffer);
        return reward;
    }

    @Override
    public boolean rewardPlayer(EntityPlayerMP playerMP) {
        if (InventoryProviderServer.getPlayerInventory().haveEnoughSpace((EntityPlayer)playerMP, this.stackWrapper, this.amount)) {
            InventoryProviderServer.getPlayerInventory().addItem((EntityPlayer)playerMP, this.stackWrapper, this.amount);
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)playerMP, (int)OxygenSoundEffects.INVENTORY_OPERATION.getId());
            if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Daily Rewards] <{}/{}> [2]: player rewarded with ITEM - name <{}>, amount {}.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)this.getItemStack().func_82833_r(), (Object)this.amount);
            }
            return true;
        }
        OxygenManagerServer.instance().sendStatusMessage(playerMP, EnumOxygenStatusMessage.INVENTORY_FULL, new String[0]);
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GUISimpleElement widget, int mouseX, int mouseY) {
        Minecraft mc = ClientReference.getMinecraft();
        String amountStr = String.format("x%d", this.amount);
        float scale = widget.getScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)widget.getX(), (float)widget.getY(), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(16.0f * scale), (float)(16.0f * scale), (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f * scale), (float)(1.0f * scale), (float)(1.0f * scale));
        mc.func_175599_af().func_180450_b(this.getItemStack(), 0, 0);
        GlStateManager.func_179121_F();
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float textScale = scale == 1.0f ? widget.getTextScale() - 0.1f : widget.getTextScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(widget.getWidth() - widget.textWidth(amountStr, textScale)) / 2.0f), (float)(34.0f * scale), (float)0.0f);
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
        mc.field_71466_p.func_175065_a(amountStr, 0.0f, 0.0f, widget.getEnabledTextColor(), false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @Override
    public ItemStack getItemStack() {
        return this.stackWrapper.getCachedItemStack();
    }
}

