/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.common.reward;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.currency.CurrencyProperties;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.CurrencyHelperServer;
import austeretony.oxygen_core.server.api.SoundEventHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.reward.EnumReward;
import austeretony.oxygen_dailyrewards.common.reward.Reward;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RewardCurrency
implements Reward {
    private String description;
    private int day;
    private int currencyIndex;
    private long amount;
    private boolean special;

    @Override
    public EnumReward getType() {
        return EnumReward.CURRENCY;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTooltip() {
        return OxygenHelperClient.getCurrencyProperties((int)this.currencyIndex).getLocalizedName();
    }

    @Override
    public boolean isSpecial() {
        return this.special;
    }

    public static Reward fromJson(JsonObject jsonObject) {
        RewardCurrency reward = new RewardCurrency();
        reward.day = jsonObject.get("day").getAsInt();
        reward.description = jsonObject.get("description").getAsString();
        reward.amount = jsonObject.get("amount").getAsLong();
        reward.special = jsonObject.get("special").getAsBoolean();
        reward.currencyIndex = jsonObject.get("currency_index").getAsInt();
        return reward;
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeByte(this.day);
        ByteBufUtils.writeString((String)this.description, (ByteBuf)buffer);
        buffer.writeLong(this.amount);
        buffer.writeBoolean(this.special);
        buffer.writeByte(this.currencyIndex);
    }

    public static Reward read(ByteBuf buffer) {
        RewardCurrency reward = new RewardCurrency();
        reward.day = buffer.readByte();
        reward.description = ByteBufUtils.readString((ByteBuf)buffer);
        reward.amount = buffer.readLong();
        reward.special = buffer.readBoolean();
        reward.currencyIndex = buffer.readByte();
        return reward;
    }

    @Override
    public boolean rewardPlayer(EntityPlayerMP playerMP) {
        CurrencyHelperServer.addCurrency((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (long)this.amount, (int)this.currencyIndex);
        SoundEventHelperServer.playSoundClient((EntityPlayerMP)playerMP, (int)OxygenSoundEffects.RINGING_COINS.getId());
        if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
            OxygenMain.LOGGER.info("[Daily Rewards] <{}/{}> [2]: player rewarded with CURRENCY - index <{}>, amount {}.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)this.currencyIndex, (Object)this.amount);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GUISimpleElement widget, int mouseX, int mouseY) {
        Minecraft mc = ClientReference.getMinecraft();
        String amountStr = String.format("x%d", this.amount);
        CurrencyProperties currencyProperties = OxygenHelperClient.getCurrencyProperties((int)this.currencyIndex);
        float scale = widget.getScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)widget.getX(), (float)widget.getY(), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(currencyProperties.getIcon());
        GUIAdvancedElement.drawCustomSizedTexturedRect((int)(20 * (int)scale + currencyProperties.getXOffset() * (int)scale), (int)(20 * (int)scale + currencyProperties.getYOffset() * (int)scale), (int)0, (int)0, (int)(currencyProperties.getIconWidth() * (int)scale), (int)(currencyProperties.getIconHeight() * (int)scale), (int)(currencyProperties.getIconWidth() * (int)scale), (int)(currencyProperties.getIconHeight() * (int)scale));
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float textScale = scale == 1.0f ? widget.getTextScale() - 0.1f : widget.getTextScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(widget.getWidth() - widget.textWidth(amountStr, textScale)) / 2.0f), (float)(30.0f * scale), (float)0.0f);
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
        mc.field_71466_p.func_175065_a(amountStr, 0.0f, 0.0f, widget.getEnabledTextColor(), false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }
}

