/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.client.gui.rewards;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.framework.GUIElementsFramework;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.api.TimeHelperClient;
import austeretony.oxygen_core.client.gui.elements.OxygenDefaultBackgroundWithButtonsFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_dailyrewards.client.DailyRewardsManagerClient;
import austeretony.oxygen_dailyrewards.client.gui.rewards.DailyRewardWidget;
import austeretony.oxygen_dailyrewards.client.gui.rewards.DailyRewardWidgetBig;
import austeretony.oxygen_dailyrewards.client.gui.rewards.DailyRewardsMenuScreen;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.main.EnumDailyRewardsPrivilege;
import austeretony.oxygen_dailyrewards.common.reward.Reward;
import java.time.Duration;
import java.time.Month;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public class RewardsSection
extends AbstractGUISection {
    private static final int WIDGETS_PER_LIST = 7;
    private static final int WIDGET_WIDTH = 48;
    private static final int WIDGET_HEIGHT = 48;
    private OxygenTextLabel nextRewardTimeLabel;
    private OxygenKeyButton prevWeekButton;
    private OxygenKeyButton nextWeekButton;
    private OxygenKeyButton claimRewardButton;
    private GUIElementsFramework framework;
    private int currentDay;
    private int daysRewarded;
    private int totalRewardsAmount;
    private int listedWeek;
    private int maxListedWeek;
    private boolean initialized;
    private boolean rewardClaimed;

    public RewardsSection(DailyRewardsMenuScreen screen) {
        super((AbstractGUIScreen)screen);
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenDefaultBackgroundWithButtonsFiller(0, 0, this.getWidth(), this.getHeight()));
        String menuTitle = ClientReference.localize((String)"oxygen_dailyrewards.gui.dailyrewards.menu.title", (Object[])new Object[0]);
        this.currentDay = 0;
        this.totalRewardsAmount = DailyRewardsManagerClient.instance().getRewardsDataContainer().getRewards().size();
        if (DailyRewardsConfig.REWARD_MODE.asInt() == 0) {
            ZonedDateTime currentTime = TimeHelperClient.getServerZonedDateTime();
            this.currentDay = currentTime.getDayOfMonth();
            Month month = currentTime.getMonth();
            this.totalRewardsAmount = month == Month.FEBRUARY ? Month.FEBRUARY.length(currentTime.toLocalDate().isLeapYear()) : month.minLength();
            String monthName = ClientReference.localize((String)("oxygen_core.month." + month.getDisplayName(TextStyle.FULL, Locale.ROOT).toLowerCase()), (Object[])new Object[0]);
            menuTitle = ClientReference.localize((String)"oxygen_dailyrewards.gui.dailyrewards.title", (Object[])new Object[]{monthName});
        }
        this.maxListedWeek = this.totalRewardsAmount / 7 + (this.totalRewardsAmount % 7 == 0 ? 0 : 1);
        this.addElement((GUIBaseElement)new OxygenTextLabel(4, 12, menuTitle, EnumBaseGUISetting.TEXT_TITLE_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.claimRewardButton = (OxygenKeyButton)new OxygenKeyButton(0, this.getY() + this.getHeight() + this.screen.guiTop - 8, ClientReference.localize((String)"oxygen_dailyrewards.gui.dailyrewards.button.claimReward", (Object[])new Object[0]), 18, this::claimReward).disable();
        this.addElement((GUIBaseElement)this.claimRewardButton);
        this.nextRewardTimeLabel = new OxygenTextLabel(this.getWidth(), this.getY() + this.getHeight() + this.screen.guiTop - 1, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt());
        this.addElement((GUIBaseElement)this.nextRewardTimeLabel);
        this.prevWeekButton = (OxygenKeyButton)new OxygenKeyButton(0, this.getY() + this.getHeight() + this.screen.guiTop - 8, ClientReference.localize((String)"oxygen_dailyrewards.gui.dailyrewards.button.prevWeek", (Object[])new Object[0]), 30, this::switchWeekBack).disable();
        this.addElement((GUIBaseElement)this.prevWeekButton);
        this.nextWeekButton = (OxygenKeyButton)new OxygenKeyButton(0, this.getY() + this.getHeight() + this.screen.guiTop - 8, ClientReference.localize((String)"oxygen_dailyrewards.gui.dailyrewards.button.nextWeek", (Object[])new Object[0]), 32, this::switchWeekForward).disable();
        this.addElement((GUIBaseElement)this.nextWeekButton);
        this.framework = new GUIElementsFramework(this.screen, 6, 16, 243, 97);
        this.addElement((GUIBaseElement)this.framework);
        this.rewardClaimed = !DailyRewardsManagerClient.instance().getPlayerData().isRewardAvailable();
        this.daysRewarded = DailyRewardsManagerClient.instance().getPlayerData().getDaysRewarded();
        this.listedWeek = this.daysRewarded / 7;
        this.listRewards(this.listedWeek * 7 + 1);
        this.updateButtonsState();
    }

    private void calculateButtonsHorizontalPosition() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        this.claimRewardButton.setX((sr.func_78326_a() - (12 + this.textWidth(this.claimRewardButton.getDisplayText(), this.claimRewardButton.getTextScale()))) / 2 - this.screen.guiLeft);
        this.prevWeekButton.setX(sr.func_78326_a() / 2 - 50 - (12 + this.textWidth(this.prevWeekButton.getDisplayText(), this.prevWeekButton.getTextScale())) - this.screen.guiLeft);
        this.nextWeekButton.setX(sr.func_78326_a() / 2 + 50 - this.screen.guiLeft);
    }

    private void listRewards(int fromDay) {
        this.framework.getElements().clear();
        int index = 0;
        int maximumRewards = PrivilegesProviderClient.getAsInt((int)EnumDailyRewardsPrivilege.MAXIMUM_REWARDS_AMOUNT_PER_MONTH.id(), (int)DailyRewardsConfig.MAXIMUM_REWARDS_PER_MONTH.asInt());
        for (int i = fromDay; i < fromDay + 7 && i <= this.totalRewardsAmount; ++i) {
            boolean unreachable;
            Reward reward = DailyRewardsManagerClient.instance().getRewardsDataContainer().getDailyReward(i);
            if (reward == null) continue;
            boolean rewarded = i <= this.daysRewarded;
            boolean nextReward = i == this.daysRewarded + 1 && i <= this.totalRewardsAmount - this.currentDay + 1;
            boolean locked = this.rewardClaimed || i > this.daysRewarded + 1;
            boolean bl = unreachable = i > this.totalRewardsAmount - this.currentDay + this.daysRewarded + (this.rewardClaimed ? 0 : 1) || i > maximumRewards;
            if (index < 3) {
                this.framework.addElement((GUIBaseElement)new DailyRewardWidget(6 + index++ * 49, 16, reward, rewarded, nextReward, locked, unreachable));
                continue;
            }
            if (index < 6) {
                this.framework.addElement((GUIBaseElement)new DailyRewardWidget(6 + (index++ - 3) * 49, 65, reward, rewarded, nextReward, locked, unreachable));
                continue;
            }
            if (index != 6) continue;
            this.framework.addElement((GUIBaseElement)new DailyRewardWidgetBig(153, 16, reward, rewarded, nextReward, locked, unreachable));
        }
    }

    private void updateButtonsState() {
        this.claimRewardButton.setEnabled(!this.rewardClaimed);
        this.prevWeekButton.setEnabled(this.listedWeek != 0);
        this.nextWeekButton.setEnabled(this.listedWeek < this.maxListedWeek - 1);
    }

    private void claimReward() {
        Minecraft.func_71410_x().field_71439_g.func_71165_d("/oxygens dailyrewards -claim");
    }

    private void switchWeekBack() {
        this.listRewards(7 * --this.listedWeek + 1);
        this.updateButtonsState();
    }

    private void switchWeekForward() {
        this.listRewards(7 * ++this.listedWeek + 1);
        this.updateButtonsState();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.claimRewardButton) {
                this.claimReward();
            } else if (element == this.prevWeekButton) {
                this.switchWeekBack();
            } else if (element == this.nextWeekButton) {
                this.switchWeekForward();
            }
        }
    }

    public void update() {
        if (this.rewardClaimed && this.mc.field_71439_g.field_70173_aa % 20 == 0) {
            Duration duration = DailyRewardsManagerClient.instance().getPlayerData().getTimeLeftUntilNextReward();
            if (duration.getSeconds() <= 0L) {
                this.rewardClaimed = false;
                this.nextRewardTimeLabel.setDisplayText("");
                this.listRewards(this.listedWeek * 7 + 1);
                this.updateButtonsState();
                return;
            }
            this.nextRewardTimeLabel.setDisplayText(String.format("%d:%02d:%02d %s", duration.getSeconds() / 3600L, duration.getSeconds() % 3600L / 60L, duration.getSeconds() % 60L, this.currentDay == this.totalRewardsAmount ? ClientReference.localize((String)"oxygen_dailyrewards.gui.dailyrewards.nextMonthBegins", (Object[])new Object[0]) : ""));
            ScaledResolution sr = new ScaledResolution(this.mc);
            this.nextRewardTimeLabel.setX(sr.func_78326_a() - this.screen.guiLeft - 4 - this.textWidth(this.nextRewardTimeLabel.getDisplayText(), this.nextRewardTimeLabel.getTextScale()));
        }
        if (!this.initialized) {
            this.initialized = true;
            this.calculateButtonsHorizontalPosition();
        }
    }

    public void rewardClaimed() {
        this.rewardClaimed = true;
        ++this.daysRewarded;
        this.listedWeek = (this.daysRewarded + 1) / 7;
        this.listRewards(DailyRewardsConfig.REWARD_MODE.asInt() == 0 ? this.listedWeek * 7 + 1 : 1);
        this.updateButtonsState();
    }
}

