/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.sync;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncAbsentData;
import austeretony.oxygen_core.common.network.client.CPSyncValidDataIds;
import austeretony.oxygen_core.server.network.NetworkRequestsRegistryServer;
import austeretony.oxygen_core.server.sync.DataSyncHandlerServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class DataSyncManagerServer {
    private final Map<Integer, DataSyncHandlerServer> handlers = new HashMap<Integer, DataSyncHandlerServer>(5);

    public void registerHandler(DataSyncHandlerServer handler) {
        this.handlers.put(handler.getDataId(), handler);
        NetworkRequestsRegistryServer.registerRequest(handler.getDataId() + 1000, 2000);
        NetworkRequestsRegistryServer.registerRequest(handler.getDataId() + 2000, 2000);
    }

    public void syncData(EntityPlayerMP playerMP, int dataId) {
        DataSyncHandlerServer handler = this.getHandler(dataId);
        if (handler != null) {
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
            if (!handler.allowSync(playerUUID)) {
                return;
            }
            Set<Long> idsSet = handler.getIds(playerUUID);
            long[] ids = new long[idsSet.size()];
            int index = 0;
            for (long id : idsSet) {
                ids[index++] = id;
            }
            OxygenMain.network().sendTo(new CPSyncValidDataIds(dataId, ids), playerMP);
        }
    }

    public DataSyncHandlerServer getHandler(int dataId) {
        return this.handlers.get(dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAbsentData(EntityPlayerMP playerMP, int dataId, long[] ids) {
        DataSyncHandlerServer handler = this.getHandler(dataId);
        if (handler != null) {
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
            if (!handler.allowSync(playerUUID)) {
                return;
            }
            if (ids.length <= handler.getIds(playerUUID).size()) {
                ByteBuf buffer = null;
                try {
                    buffer = Unpooled.buffer((int)8191);
                    int entriesAmount = 0;
                    for (long id : ids) {
                        Object entry = handler.getEntry(playerUUID, id);
                        if (entry == null) continue;
                        entry.write(buffer);
                        ++entriesAmount;
                    }
                    if (entriesAmount > 0) {
                        if (buffer.writerIndex() > 0xC800000) {
                            OxygenMain.LOGGER.error("[Core] Data {} synchronization buffer exceeds maximum packet payload ({}/209715200 bytes) for player {}, it will not be synchronized!", (Object)dataId, (Object)buffer.writerIndex(), (Object)CommonReference.getName((Entity)playerMP));
                        } else {
                            byte[] rawEntries = new byte[buffer.writerIndex()];
                            buffer.readBytes(rawEntries);
                            OxygenMain.network().sendTo(new CPSyncAbsentData(dataId, entriesAmount, rawEntries), playerMP);
                        }
                    }
                }
                finally {
                    if (buffer != null) {
                        buffer.release();
                    }
                }
            }
        }
    }
}

