/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.privilege;

import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.config.OxygenConfig;
import austeretony.oxygen_core.common.config.PrivilegesConfig;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPDefaultPrivilegeOperation;
import austeretony.oxygen_core.common.network.client.CPPlayerRolesChanged;
import austeretony.oxygen_core.common.network.client.CPRoleAction;
import austeretony.oxygen_core.common.network.client.CPRolePrivilegeOperation;
import austeretony.oxygen_core.common.network.client.CPSyncPlayerRoles;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.PrivilegeRegistry;
import austeretony.oxygen_core.common.privilege.PrivilegeUtils;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.privilege.RoleImpl;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;

public class PrivilegesManagerServer {
    private final OxygenManagerServer manager;

    public PrivilegesManagerServer(OxygenManagerServer manager) {
        this.manager = manager;
    }

    private void roleRemoved(int roleId) {
        for (UUID playerUUID : this.manager.getPrivilegesContainer().getPlayersRoles().keySet()) {
            this.removeRoleFromPlayer(playerUUID, roleId);
        }
    }

    public void addDefaultRoles() {
        if (this.manager.getPrivilegesContainer().getRole(100) == null) {
            this.manager.getPrivilegesContainer().addRole(new RoleImpl("Operator", 100, TextFormatting.AQUA));
            this.manager.getPrivilegesContainer().markChanged();
        }
    }

    public void addRoleToPlayerFast(UUID playerUUID, int roleId) {
        Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
        if (ids != null) {
            if (ids.size() < 5) {
                ids.add(roleId);
            }
        } else {
            ids = new TreeSet<Integer>((i, j) -> j - i);
            ids.add(roleId);
            this.manager.getPrivilegesContainer().setPlayerRolesIds(playerUUID, ids);
            this.manager.getPrivilegesContainer().setPlayerChatFormattingRole(playerUUID, roleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRoleToPlayer(UUID playerUUID, int roleId) {
        if (this.manager.getPrivilegesContainer().getRole(roleId) != null) {
            boolean added = false;
            Map<UUID, Set<Integer>> map = this.manager.getPrivilegesContainer().getPlayersRoles();
            synchronized (map) {
                Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
                if (ids != null) {
                    if (ids.size() < 5) {
                        added = ids.add(roleId);
                    }
                } else {
                    ids = new TreeSet<Integer>((i, j) -> j - i);
                    added = ids.add(roleId);
                    this.manager.getPrivilegesContainer().setPlayerRolesIds(playerUUID, ids);
                    this.manager.getPrivilegesContainer().setPlayerChatFormattingRole(playerUUID, roleId);
                }
            }
            if (added) {
                if (OxygenHelperServer.isPlayerOnline(playerUUID)) {
                    this.syncPlayerPrivileges(playerUUID);
                }
                this.updatePlayerRolesSharedData(playerUUID);
                this.manager.getPrivilegesContainer().markChanged();
            }
            return added;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRoleFromPlayer(UUID playerUUID, int roleId) {
        boolean removed = false;
        Map<UUID, Set<Integer>> map = this.manager.getPrivilegesContainer().getPlayersRoles();
        synchronized (map) {
            Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
            if (ids != null && (removed = ids.remove(roleId))) {
                if (ids.isEmpty()) {
                    this.manager.getPrivilegesContainer().removePlayerRolesIds(playerUUID);
                    this.manager.getPrivilegesContainer().removePlayerChatFormattingRole(playerUUID);
                } else if (this.manager.getPrivilegesContainer().getPlayerChatFormattingRole(playerUUID) == roleId) {
                    this.manager.getPrivilegesContainer().setPlayerChatFormattingRole(playerUUID, (Integer)((TreeSet)ids).first());
                }
            }
        }
        if (removed) {
            if (OxygenHelperServer.isPlayerOnline(playerUUID)) {
                this.syncPlayerPrivileges(playerUUID);
            }
            this.updatePlayerRolesSharedData(playerUUID);
            this.manager.getPrivilegesContainer().markChanged();
        }
        return removed;
    }

    public void setPlayerChatFormattingRole(UUID playerUUID, int roleId) {
        Set<Integer> ids;
        if (PrivilegesConfig.ENABLE_CHAT_FORMATTING_ROLE_MANAGEMENT.asBoolean() && (ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID)) != null && (ids.contains(roleId) || roleId == -1)) {
            this.manager.getPrivilegesContainer().setPlayerChatFormattingRole(playerUUID, roleId);
            this.manager.getPrivilegesContainer().markChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerRolesSharedData(UUID playerUUID) {
        Map<UUID, Set<Integer>> map = this.manager.getPrivilegesContainer().getPlayersRoles();
        synchronized (map) {
            PlayerSharedData sharedData = OxygenHelperServer.getPlayerSharedData(playerUUID);
            if (sharedData != null) {
                Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
                if (ids != null) {
                    Iterator<Integer> iterator = ids.iterator();
                    for (int i = 0; i < 5; ++i) {
                        int roleId = -1;
                        if (iterator.hasNext()) {
                            roleId = iterator.next();
                        }
                        sharedData.setByte(i + 10, roleId);
                    }
                } else {
                    for (int i = 0; i < 5; ++i) {
                        sharedData.setByte(i + 10, -1);
                    }
                }
                OxygenManagerServer.instance().getSharedDataManager().setChanged(true);
            }
        }
    }

    @Nullable
    public Role getChatFormattingPlayerRole(UUID playerUUID) {
        if (PrivilegesConfig.ENABLE_CHAT_FORMATTING_ROLE_MANAGEMENT.asBoolean()) {
            int formattingRole = this.manager.getPrivilegesContainer().getPlayerChatFormattingRole(playerUUID);
            if (formattingRole != -1) {
                return this.manager.getPrivilegesContainer().getRole(formattingRole);
            }
        } else {
            return this.getPriorityPlayerRole(playerUUID);
        }
        return null;
    }

    @Nullable
    public Role getPriorityPlayerRole(UUID playerUUID) {
        Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
        if (ids != null) {
            return this.manager.getPrivilegesContainer().getRole((Integer)((TreeSet)ids).first());
        }
        return null;
    }

    @Nullable
    public Privilege getPriorityPlayerPrivilege(UUID playerUUID, int privilegeId) {
        Privilege privilege = null;
        Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
        if (ids != null) {
            for (int roleId : ids) {
                Role role = this.manager.getPrivilegesContainer().getRole(roleId);
                privilege = role.getPrivilege(privilegeId);
                if (privilege == null) continue;
                return privilege;
            }
        }
        return this.manager.getPrivilegesContainer().getDefaultPrivilege(privilegeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncPlayerPrivileges(UUID playerUUID) {
        Map<UUID, Set<Integer>> map = this.manager.getPrivilegesContainer().getPlayersRoles();
        synchronized (map) {
            ByteBuf buffer = null;
            try {
                buffer = Unpooled.buffer();
                buffer.writeShort(this.manager.getPrivilegesContainer().getDefaultPrivileges().size());
                for (Privilege privilege : this.manager.getPrivilegesContainer().getDefaultPrivileges()) {
                    privilege.write(buffer);
                }
                Set<Integer> ids = this.manager.getPrivilegesContainer().getPlayerRolesIds(playerUUID);
                if (ids != null) {
                    buffer.writeBoolean(true);
                    if (PrivilegesConfig.ENABLE_CHAT_FORMATTING_ROLE_MANAGEMENT.asBoolean()) {
                        buffer.writeByte(this.manager.getPrivilegesContainer().getPlayerChatFormattingRole(playerUUID));
                    } else {
                        buffer.writeByte(((Integer)((TreeSet)ids).first()).intValue());
                    }
                    buffer.writeByte(ids.size());
                    for (int roleId : ids) {
                        this.manager.getPrivilegesContainer().getRole(roleId).write(buffer);
                    }
                } else {
                    buffer.writeBoolean(false);
                }
                byte[] byArray = new byte[buffer.writerIndex()];
                buffer.getBytes(0, byArray);
                OxygenMain.network().sendTo(new CPSyncPlayerRoles(byArray), CommonReference.playerByUUID(playerUUID));
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
    }

    public void createRole(EntityPlayerMP playerMP, int roleId, String roleName, String prefix, int roleNameColor, int prefixColor, int usernameColor, int chatColor) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && roleId != 100 && roleId >= 0 && roleId <= 127 && roleNameColor >= 0 && roleNameColor < 16 && prefixColor >= 0 && prefixColor < 16 && usernameColor >= 0 && usernameColor < 16 && chatColor >= 0 && chatColor < 16) {
            if (this.manager.getPrivilegesContainer().getRole(roleId) != null) {
                return;
            }
            roleName = roleName.trim();
            prefix = prefix.trim();
            if (roleName.length() > 24) {
                roleName = roleName.substring(0, 24);
            }
            if (prefix.length() > 16) {
                prefix = prefix.substring(0, 16);
            }
            RoleImpl role = new RoleImpl(roleName, roleId, TextFormatting.values()[roleNameColor]);
            role.setPrefix(prefix);
            role.setPrefixColor(TextFormatting.values()[prefixColor]);
            role.setUsernameColor(TextFormatting.values()[usernameColor]);
            role.setChatColor(TextFormatting.values()[chatColor]);
            this.manager.getPrivilegesContainer().addRole(role);
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            this.manager.getPrivilegesContainer().syncPrivilegesData(playerMP);
            OxygenMain.network().sendTo(new CPRoleAction(CPRoleAction.EnumAction.CREATED, role), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.ROLE_CREATED, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> created role <{}({})>.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)roleName, (Object)roleId);
            }
        }
    }

    public void editRole(EntityPlayerMP playerMP, int roleId, String roleName, String prefix, int roleNameColor, int prefixColor, int usernameColor, int chatColor) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && roleId != 100 && roleId >= 0 && roleId <= 127 && roleNameColor >= 0 && roleNameColor < 16 && prefixColor >= 0 && prefixColor < 16 && usernameColor >= 0 && usernameColor < 16 && chatColor >= 0 && chatColor < 16) {
            RoleImpl role = (RoleImpl)this.manager.getPrivilegesContainer().getRole(roleId);
            if (role == null) {
                return;
            }
            roleName = roleName.trim();
            prefix = prefix.trim();
            if (roleName.length() > 24) {
                roleName = roleName.substring(0, 24);
            }
            if (prefix.length() > 16) {
                prefix = prefix.substring(0, 16);
            }
            role.setName(roleName);
            role.setPrefix(prefix);
            role.setNameColor(TextFormatting.values()[roleNameColor]);
            role.setPrefixColor(TextFormatting.values()[prefixColor]);
            role.setUsernameColor(TextFormatting.values()[usernameColor]);
            role.setChatColor(TextFormatting.values()[chatColor]);
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            this.manager.getPrivilegesContainer().syncPrivilegesData(playerMP);
            OxygenMain.network().sendTo(new CPRoleAction(CPRoleAction.EnumAction.EDITED, role), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.ROLE_EDITED, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> edited role ({}).", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)roleId);
            }
        }
    }

    public void removeRole(EntityPlayerMP playerMP, int roleId) {
        Role role;
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && roleId != 100 && (role = this.manager.getPrivilegesContainer().removeRole(roleId)) != null) {
            this.roleRemoved(roleId);
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            OxygenMain.network().sendTo(new CPRoleAction(CPRoleAction.EnumAction.REMOVED, role), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.ROLE_REMOVED, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> removed role <{}({})>.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)role.getName(), (Object)roleId);
            }
        }
    }

    public void addPrivilege(EntityPlayerMP playerMP, int roleId, int privilegeId, String value) {
        Privilege privilege;
        Role role;
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && roleId != 100 && (role = this.manager.getPrivilegesContainer().getRole(roleId)) != null && (privilege = PrivilegesManagerServer.createPrivilege(privilegeId, value)) != null) {
            role.addPrivilege(privilege);
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            OxygenMain.network().sendTo(new CPRolePrivilegeOperation(CPRolePrivilegeOperation.EnumAction.ADDED, role.getId(), privilege), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.PRIVILEGE_ADDED, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> added privilege ({}) with value [{}] to role <{}({})>.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)privilegeId, (Object)value, (Object)role.getName(), (Object)roleId);
            }
        }
    }

    public void removePrivilege(EntityPlayerMP playerMP, int roleId, int privilegeId) {
        Privilege privilege;
        Role role;
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && roleId != 100 && (role = this.manager.getPrivilegesContainer().getRole(roleId)) != null && (privilege = role.removePrivilege(privilegeId)) != null) {
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            OxygenMain.network().sendTo(new CPRolePrivilegeOperation(CPRolePrivilegeOperation.EnumAction.REMOVED, role.getId(), privilege), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.PRIVILEGE_REMOVED, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> removed privilege ({}) from role <{}({})>.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)privilegeId, (Object)role.getName(), (Object)roleId);
            }
        }
    }

    public void addDefaultPrivilege(EntityPlayerMP playerMP, int privilegeId, String value) {
        Privilege privilege;
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && (privilege = PrivilegesManagerServer.createPrivilege(privilegeId, value)) != null) {
            this.manager.getPrivilegesContainer().addDefaultPrivilege(privilege);
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            OxygenMain.network().sendTo(new CPDefaultPrivilegeOperation(CPDefaultPrivilegeOperation.EnumOperation.ADDED, privilege), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.DEFAULT_PRIVILEGE_ADDED, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> added default privilege ({}) with value [{}].", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)privilegeId, (Object)value);
            }
        }
    }

    public void removeDefaultPrivilege(EntityPlayerMP playerMP, int privilegeId) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP)) {
            Privilege privilege = this.manager.getPrivilegesContainer().removeDefaultPrivilege(privilegeId);
            this.manager.getPrivilegesContainer().compressPrivilegesData();
            this.manager.getPrivilegesContainer().markChanged();
            if (privilege != null) {
                OxygenMain.network().sendTo(new CPDefaultPrivilegeOperation(CPDefaultPrivilegeOperation.EnumOperation.REMOVED, privilege), playerMP);
                this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.DEFAULT_PRIVILEGE_REMOVED, new String[0]);
                if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                    OxygenMain.LOGGER.info("[Core] <{}/{}> removed default privilege ({}).", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)privilegeId);
                }
            }
        }
    }

    @Nullable
    private static Privilege createPrivilege(int privilegeId, String value) {
        PrivilegeRegistry.PrivilegeRegistryEntry entry = PrivilegeRegistry.getRegistryEntry(privilegeId);
        if (entry != null) {
            value = value.trim();
            switch (entry.type) {
                case BOOLEAN: {
                    return PrivilegeUtils.getPrivilege(privilegeId, Boolean.parseBoolean(value));
                }
                case INT: {
                    try {
                        return PrivilegeUtils.getPrivilege(privilegeId, Integer.parseInt(value));
                    }
                    catch (NumberFormatException exception) {
                        OxygenMain.LOGGER.error("[Core] Wrong privilege integer value!", (Throwable)exception);
                    }
                }
                case FLOAT: {
                    try {
                        return PrivilegeUtils.getPrivilege(privilegeId, Float.parseFloat(value));
                    }
                    catch (NumberFormatException exception) {
                        OxygenMain.LOGGER.error("[Core] Wrong privilege float value!", (Throwable)exception);
                    }
                }
                case LONG: {
                    try {
                        return PrivilegeUtils.getPrivilege(privilegeId, Long.parseLong(value));
                    }
                    catch (NumberFormatException exception) {
                        OxygenMain.LOGGER.error("[Core] Wrong privilege long value!", (Throwable)exception);
                    }
                }
                case STRING: {
                    return PrivilegeUtils.getPrivilege(privilegeId, value);
                }
            }
            return null;
        }
        return null;
    }

    public void addRoleToPlayer(EntityPlayerMP playerMP, UUID playerUUID, int roleId) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && OxygenHelperServer.getPlayerSharedData(playerUUID) != null && this.addRoleToPlayer(playerUUID, roleId)) {
            OxygenMain.network().sendTo(new CPPlayerRolesChanged(roleId, OxygenHelperServer.getPlayerSharedData(playerUUID)), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.ROLE_ADDED_TO_PLAYER, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> added role ({}) to {}.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)roleId, (Object)playerUUID);
            }
        }
    }

    public void removeRoleFromPlayer(EntityPlayerMP playerMP, UUID playerUUID, int roleId) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && OxygenHelperServer.getPlayerSharedData(playerUUID) != null && this.removeRoleFromPlayer(playerUUID, roleId)) {
            OxygenMain.network().sendTo(new CPPlayerRolesChanged(roleId, OxygenHelperServer.getPlayerSharedData(playerUUID)), playerMP);
            this.manager.sendStatusMessage(playerMP, EnumOxygenStatusMessage.ROLE_REMOVED_FROM_PLAYER, new String[0]);
            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                OxygenMain.LOGGER.info("[Core] <{}/{}> removed role ({}) from {}.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)roleId, (Object)playerUUID);
            }
        }
    }
}

