/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.privilege;

import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncPrivilegesManagementData;
import austeretony.oxygen_core.common.network.client.CPSyncRolesData;
import austeretony.oxygen_core.common.privilege.EnumPrivilegeFileKey;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.PrivilegeUtils;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.privilege.RoleImpl;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.event.OxygenPrivilegesLoadedEvent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PrivilegesContainerServer {
    private final OxygenManagerServer manager;
    private final Map<Integer, Privilege> defaultPrivileges = new ConcurrentHashMap<Integer, Privilege>();
    private final Map<Integer, Role> roles = new ConcurrentHashMap<Integer, Role>(3);
    private final Map<UUID, Set<Integer>> playersRoles = new ConcurrentHashMap<UUID, Set<Integer>>();
    private final Map<UUID, Integer> formattingRoles = new ConcurrentHashMap<UUID, Integer>();
    private ByteBuf compressedRolesData = Unpooled.buffer();
    private volatile boolean changed;

    public PrivilegesContainerServer(OxygenManagerServer manager) {
        this.manager = manager;
    }

    public Collection<Privilege> getDefaultPrivileges() {
        return this.defaultPrivileges.values();
    }

    @Nullable
    public Privilege getDefaultPrivilege(int privilegeId) {
        return this.defaultPrivileges.get(privilegeId);
    }

    public void addDefaultPrivilege(Privilege privilege) {
        this.defaultPrivileges.put(privilege.getId(), privilege);
    }

    @Nullable
    public Privilege removeDefaultPrivilege(int privilegeId) {
        return this.defaultPrivileges.remove(privilegeId);
    }

    public Set<Integer> getRolesIds() {
        return this.roles.keySet();
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    @Nullable
    public Role getRole(int roleId) {
        return this.roles.get(roleId);
    }

    public void addRole(Role role) {
        this.roles.put(role.getId(), role);
    }

    @Nullable
    public Role removeRole(int roleId) {
        return this.roles.remove(roleId);
    }

    public Map<UUID, Set<Integer>> getPlayersRoles() {
        return this.playersRoles;
    }

    @Nullable
    public Set<Integer> getPlayerRolesIds(UUID playerUUID) {
        Set<Integer> ids = this.playersRoles.get(playerUUID);
        if (ids != null) {
            return ids;
        }
        return null;
    }

    public void setPlayerRolesIds(UUID playerUUID, Set<Integer> ids) {
        this.playersRoles.put(playerUUID, ids);
    }

    public void removePlayerRolesIds(UUID playerUUID) {
        this.playersRoles.remove(playerUUID);
    }

    public void setPlayerChatFormattingRole(UUID playerUUID, int roleId) {
        this.formattingRoles.put(playerUUID, roleId);
    }

    public void removePlayerChatFormattingRole(UUID playerUUID) {
        this.formattingRoles.remove(playerUUID);
    }

    public int getPlayerChatFormattingRole(UUID playerUUID) {
        Integer formattingRole = this.formattingRoles.get(playerUUID);
        return formattingRole == null ? -1 : formattingRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressPrivilegesData() {
        ByteBuf byteBuf = this.compressedRolesData;
        synchronized (byteBuf) {
            this.compressedRolesData.clear();
            this.compressedRolesData.writeByte(this.roles.size());
            for (Role role : this.roles.values()) {
                this.compressedRolesData.writeByte(role.getId());
                ByteBufUtils.writeString(role.getName(), this.compressedRolesData);
                this.compressedRolesData.writeByte(role.getNameColor().ordinal());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncPrivilegesData(EntityPlayerMP playerMP) {
        ByteBuf byteBuf = this.compressedRolesData;
        synchronized (byteBuf) {
            byte[] compressed = new byte[this.compressedRolesData.writerIndex()];
            this.compressedRolesData.getBytes(0, compressed);
            OxygenMain.network().sendTo(new CPSyncRolesData(compressed), playerMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncManagementData(EntityPlayerMP playerMP) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP)) {
            ByteBuf buffer = null;
            try {
                buffer = Unpooled.buffer();
                buffer.writeShort(this.defaultPrivileges.size());
                for (Privilege privilege : this.defaultPrivileges.values()) {
                    privilege.write(buffer);
                }
                buffer.writeByte(this.roles.size());
                for (Role role : this.roles.values()) {
                    role.write(buffer);
                }
                buffer.writeShort(this.playersRoles.size());
                for (UUID playerUUID : this.playersRoles.keySet()) {
                    PlayerSharedData sharedData = OxygenHelperServer.getPlayerSharedData(playerUUID);
                    if (sharedData != null) {
                        buffer.writeBoolean(true);
                        sharedData.write(buffer);
                        continue;
                    }
                    buffer.writeBoolean(false);
                }
                byte[] byArray = new byte[buffer.writerIndex()];
                buffer.getBytes(0, byArray);
                OxygenMain.network().sendTo(new CPSyncPrivilegesManagementData(byArray), playerMP);
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
    }

    public void worldLoaded() {
        this.loadDefaultPrivileges();
        this.loadRoles();
        this.loadPlayersList();
        this.manager.getPrivilegesManager().addDefaultRoles();
        this.compressPrivilegesData();
        MinecraftForge.EVENT_BUS.post((Event)new OxygenPrivilegesLoadedEvent());
    }

    public Future<?> reload() {
        return OxygenHelperServer.addIOTask(() -> {
            this.loadDefaultPrivileges();
            this.loadRoles();
            this.loadPlayersList();
            this.compressPrivilegesData();
        });
    }

    private void loadDefaultPrivileges() {
        String folder = OxygenHelperCommon.getConfigFolder() + "data/server/privileges/default_privileges.json";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JsonArray privilegesArray = JsonUtils.getExternalJsonData(folder).getAsJsonArray();
                for (JsonElement privilegeElement : privilegesArray) {
                    this.addDefaultPrivilege(PrivilegeUtils.fromJson(privilegeElement.getAsJsonObject()));
                }
                OxygenMain.LOGGER.info("[Core] Default privileges loaded.");
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Default privileges loading failed.");
                exception.printStackTrace();
            }
        }
    }

    private void loadRoles() {
        String folder = OxygenHelperCommon.getConfigFolder() + "data/server/privileges/roles.json";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JsonArray rolesArray = JsonUtils.getExternalJsonData(folder).getAsJsonArray();
                for (JsonElement roleElement : rolesArray) {
                    this.addRole(RoleImpl.fromJson(roleElement.getAsJsonObject()));
                }
                OxygenMain.LOGGER.info("[Core] Roles loaded.");
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Roles loading failed.");
                exception.printStackTrace();
            }
        }
    }

    private void loadPlayersList() {
        String folder = OxygenHelperCommon.getConfigFolder() + "data/server/privileges/players.json";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JsonArray playersArray = JsonUtils.getExternalJsonData(folder).getAsJsonArray();
                for (JsonElement playerElement : playersArray) {
                    JsonObject playerObject = playerElement.getAsJsonObject();
                    UUID playerUUID = UUID.fromString(playerObject.get(EnumPrivilegeFileKey.PLAYER_UUID.name).getAsString());
                    JsonArray rolesIdsArray = playerObject.get(EnumPrivilegeFileKey.ROLES.name).getAsJsonArray();
                    for (JsonElement roleIdElement : rolesIdsArray) {
                        this.manager.getPrivilegesManager().addRoleToPlayerFast(playerUUID, roleIdElement.getAsInt());
                    }
                    this.manager.getPrivilegesManager().setPlayerChatFormattingRole(playerUUID, playerObject.get(EnumPrivilegeFileKey.CHAT_FORMATTING_ROLE.name).getAsInt());
                }
                OxygenMain.LOGGER.info("[Core] Loaded privileged players list.");
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Privileged players list loading failed.");
                exception.printStackTrace();
            }
        }
    }

    public Future<?> saveDefaultPrivilegesAsync() {
        return OxygenHelperServer.addIOTask(this::saveDefaultPrivileges);
    }

    public void saveDefaultPrivileges() {
        String folder = OxygenHelperCommon.getConfigFolder() + "data/server/privileges/default_privileges.json";
        Path path = Paths.get(folder, new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            JsonArray privilegesArray = new JsonArray();
            this.getDefaultPrivileges().stream().sorted((p1, p2) -> p1.getId() - p2.getId()).forEach(privilege -> privilegesArray.add((JsonElement)privilege.toJson()));
            JsonUtils.createExternalJsonFile(folder, (JsonElement)privilegesArray);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Core] Default privileges saving failed.");
            exception.printStackTrace();
        }
    }

    public Future<?> saveRolesAsync() {
        return OxygenHelperServer.addIOTask(this::saveRoles);
    }

    public void saveRoles() {
        String folder = OxygenHelperCommon.getConfigFolder() + "data/server/privileges/roles.json";
        Path path = Paths.get(folder, new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            JsonArray rolesArray = new JsonArray();
            this.getRoles().stream().sorted((r1, r2) -> r1.getId() - r2.getId()).forEach(role -> rolesArray.add((JsonElement)role.toJson()));
            JsonUtils.createExternalJsonFile(folder, (JsonElement)rolesArray);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Core] Roles saving failed.");
            exception.printStackTrace();
        }
    }

    public Future<?> savePlayersListAsync() {
        return OxygenHelperServer.addIOTask(this::savePlayersList);
    }

    public void savePlayersList() {
        String folder = OxygenHelperCommon.getConfigFolder() + "data/server/privileges/players.json";
        Path path = Paths.get(folder, new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            JsonArray playersArray = new JsonArray();
            for (Map.Entry<UUID, Set<Integer>> entry : this.playersRoles.entrySet()) {
                JsonObject playerObject = new JsonObject();
                playerObject.add(EnumPrivilegeFileKey.PLAYER_UUID.name, (JsonElement)new JsonPrimitive(entry.getKey().toString()));
                JsonArray rolesIdsArray = new JsonArray();
                for (int roleId : entry.getValue()) {
                    rolesIdsArray.add((JsonElement)new JsonPrimitive((Number)roleId));
                }
                playerObject.add(EnumPrivilegeFileKey.ROLES.name, (JsonElement)rolesIdsArray);
                playerObject.add(EnumPrivilegeFileKey.CHAT_FORMATTING_ROLE.name, (JsonElement)new JsonPrimitive((Number)this.getPlayerChatFormattingRole(entry.getKey())));
                playersArray.add((JsonElement)playerObject);
            }
            JsonUtils.createExternalJsonFile(folder, (JsonElement)playersArray);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Core] Privileged players list saving failed.");
            exception.printStackTrace();
        }
    }

    public void markChanged() {
        this.changed = true;
    }

    public void save() {
        if (this.changed) {
            this.changed = false;
            this.saveDefaultPrivilegesAsync();
            this.saveRolesAsync();
            this.savePlayersListAsync();
        }
    }
}

