/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.preset;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncPreset;
import austeretony.oxygen_core.common.network.client.CPSyncPresetsVersions;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.preset.PresetServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class PresetsManagerServer {
    private final List<PresetServer> presets = new ArrayList<PresetServer>(5);
    private long[] data;

    public List<PresetServer> getPresets() {
        return this.presets;
    }

    public void registerPreset(PresetServer preset) {
        this.presets.add(preset);
    }

    public void loadPresets() {
        OxygenHelperServer.addIOTask(() -> {
            OxygenMain.LOGGER.info("[Core] Presets loading started...");
            String folder = CommonReference.getGameFolder() + "/config/oxygen/data/server/";
            for (PresetServer preset : this.presets) {
                if (preset.load(folder + "presets/" + preset.getDirectory() + "/")) {
                    OxygenMain.LOGGER.info("[Core] Preset <{}> loaded successfully.", (Object)preset.getName());
                    continue;
                }
                OxygenMain.LOGGER.error("[Core] Failed to load preset <{}>.", (Object)preset.getName());
            }
        });
    }

    public void init() {
        this.data = new long[this.presets.size() + 1];
        this.data[0] = OxygenHelperServer.getWorldId();
        int index = 1;
        for (PresetServer preset : this.presets) {
            this.data[index++] = preset.getVersionId();
        }
    }

    public void syncVersions(EntityPlayerMP playerMP) {
        OxygenMain.network().sendTo(new CPSyncPresetsVersions(this.data), playerMP);
    }

    public void syncPreset(EntityPlayerMP playerMP, int presetId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        for (PresetServer preset : this.presets) {
            if (preset.getId() != presetId) continue;
            OxygenMain.network().sendTo(new CPSyncPreset(OxygenHelperServer.getWorldId(), preset), playerMP);
        }
    }
}

