/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.command;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.notification.SimpleNotification;
import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.config.OxygenConfig;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.scripting.ScriptWrapper;
import austeretony.oxygen_core.common.scripting.ScriptingProvider;
import austeretony.oxygen_core.common.scripting.Shell;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.CurrencyHelperServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CoreArgumentOperator
implements ArgumentExecutor {
    private Shell shell;

    @Override
    public String getName() {
        return "core";
    }

    @Override
    public void process(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 3) {
            EntityPlayerMP senderPlayerMP = null;
            if (sender instanceof EntityPlayerMP) {
                senderPlayerMP = CommandBase.func_71521_c((ICommandSender)sender);
            }
            if (args[1].equals("-privileges")) {
                if (args.length == 5) {
                    int roleId;
                    Role role;
                    EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[3]);
                    if (sender instanceof EntityPlayerMP) {
                        senderPlayerMP = CommandBase.func_71521_c((ICommandSender)sender);
                    }
                    if ((role = PrivilegesProviderServer.getRole(roleId = CommandBase.func_175764_a((String)args[4], (int)0, (int)127))) != null) {
                        if (args[2].equals("-add-role")) {
                            OxygenManagerServer.instance().getPrivilegesManager().addRoleToPlayer(CommonReference.getPersistentUUID((Entity)targetPlayerMP), roleId);
                            if (sender instanceof EntityPlayerMP) {
                                senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.role.add", new Object[]{role.getName(), CommonReference.getName((Entity)targetPlayerMP)}));
                            } else {
                                server.func_145747_a((ITextComponent)new TextComponentString(String.format("Added role <%s> to player <%s>.", role.getName(), CommonReference.getName((Entity)targetPlayerMP))));
                            }
                            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                                OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> added role <{}({})> to {}/{}.", (Object)sender.func_70005_c_(), (Object)role.getName(), (Object)roleId, (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                            }
                        } else if (args[2].equals("-remove-role")) {
                            OxygenManagerServer.instance().getPrivilegesManager().removeRoleFromPlayer(CommonReference.getPersistentUUID((Entity)targetPlayerMP), roleId);
                            if (sender instanceof EntityPlayerMP) {
                                senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.role.remove", new Object[]{role.getName(), CommonReference.getName((Entity)targetPlayerMP)}));
                            } else {
                                server.func_145747_a((ITextComponent)new TextComponentString(String.format("Removed role <%s> from player <%s>.", role.getName(), CommonReference.getName((Entity)targetPlayerMP))));
                            }
                            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                                OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> removed role <{}({})> from {}/{}.", (Object)sender.func_70005_c_(), (Object)role.getName(), (Object)roleId, (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                            }
                        }
                    }
                }
            } else if (args[1].equals("-currency")) {
                if (args.length >= 5) {
                    int currencyIndex = 0;
                    long amount = 0L;
                    if (args[2].equals("-balance")) {
                        if (args.length == 5) {
                            EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[3]);
                            currencyIndex = CommandBase.func_175764_a((String)args[4], (int)0, (int)127);
                            if (CurrencyHelperServer.getCurrencyProvider(currencyIndex) == null) {
                                throw new WrongUsageException("Invalid currency index: %s", new Object[]{currencyIndex});
                            }
                            long balance = CurrencyHelperServer.getCurrency(CommonReference.getPersistentUUID((Entity)targetPlayerMP), currencyIndex);
                            if (sender instanceof EntityPlayerMP) {
                                senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.currency.balance", new Object[]{CommonReference.getName((Entity)targetPlayerMP), String.valueOf(currencyIndex), String.valueOf(balance)}));
                            } else {
                                server.func_145747_a((ITextComponent)new TextComponentString(String.format("Player <%s> currency <%s> amount is <%s>.", CommonReference.getName((Entity)targetPlayerMP), currencyIndex, balance)));
                            }
                        }
                    } else if (args[2].equals("-set")) {
                        if (args.length == 6) {
                            EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[3]);
                            currencyIndex = CommandBase.func_175764_a((String)args[4], (int)0, (int)127);
                            amount = CommandBase.func_175760_a((String)args[5], (long)0L, (long)Long.MAX_VALUE);
                            UUID playerUUID = CommonReference.getPersistentUUID((Entity)targetPlayerMP);
                            if (CurrencyHelperServer.getCurrencyProvider(currencyIndex) == null) {
                                throw new WrongUsageException("Invalid currency index: %s", new Object[]{currencyIndex});
                            }
                            CurrencyHelperServer.setCurrency(playerUUID, amount, currencyIndex);
                            if (sender instanceof EntityPlayerMP) {
                                senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.currency.set", new Object[]{CommonReference.getName((Entity)targetPlayerMP), String.valueOf(amount), String.valueOf(currencyIndex)}));
                            } else {
                                server.func_145747_a((ITextComponent)new TextComponentString(String.format("Player <%s> set <%s> currency units with index <%s>.", CommonReference.getName((Entity)targetPlayerMP), amount, currencyIndex)));
                            }
                            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                                OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> set player {}/{} currency with index <{}> to {}.", (Object)sender.func_70005_c_(), (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP), (Object)currencyIndex, (Object)amount);
                            }
                        }
                    } else if (args[2].equals("-add")) {
                        if (args.length == 6) {
                            EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[3]);
                            currencyIndex = CommandBase.func_175764_a((String)args[4], (int)0, (int)127);
                            amount = CommandBase.func_175760_a((String)args[5], (long)0L, (long)Long.MAX_VALUE);
                            UUID playerUUID = CommonReference.getPersistentUUID((Entity)targetPlayerMP);
                            if (CurrencyHelperServer.getCurrencyProvider(currencyIndex) == null) {
                                throw new WrongUsageException("Invalid currency index: %s", new Object[]{currencyIndex});
                            }
                            CurrencyHelperServer.addCurrency(playerUUID, amount, currencyIndex);
                            if (sender instanceof EntityPlayerMP) {
                                senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.currency.add", new Object[]{CommonReference.getName((Entity)targetPlayerMP), String.valueOf(amount), String.valueOf(currencyIndex)}));
                            } else {
                                server.func_145747_a((ITextComponent)new TextComponentString(String.format("Player <%s> recieved <%s> currency units with index <%s>.", CommonReference.getName((Entity)targetPlayerMP), amount, currencyIndex)));
                            }
                            if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                                OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> added {} currency with index <{}> to player {}/{}.", (Object)sender.func_70005_c_(), (Object)amount, (Object)currencyIndex, (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                            }
                        }
                    } else if (args[2].equals("-remove") && args.length == 6) {
                        EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[3]);
                        currencyIndex = CommandBase.func_175764_a((String)args[4], (int)0, (int)127);
                        amount = CommandBase.func_175760_a((String)args[5], (long)0L, (long)Long.MAX_VALUE);
                        UUID playerUUID = CommonReference.getPersistentUUID((Entity)targetPlayerMP);
                        if (CurrencyHelperServer.getCurrencyProvider(currencyIndex) == null) {
                            throw new WrongUsageException("Invalid currency index: %s", new Object[]{currencyIndex});
                        }
                        CurrencyHelperServer.removeCurrency(playerUUID, amount, currencyIndex);
                        if (sender instanceof EntityPlayerMP) {
                            senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.currency.remove", new Object[]{CommonReference.getName((Entity)targetPlayerMP), String.valueOf(amount), String.valueOf(currencyIndex)}));
                        } else {
                            server.func_145747_a((ITextComponent)new TextComponentString(String.format("Player <%s> lost <%s> currency units with index <%s>.", CommonReference.getName((Entity)targetPlayerMP), amount, currencyIndex)));
                        }
                        if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                            OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> removed {} currency with index <{}> from player {}/{}.", (Object)sender.func_70005_c_(), (Object)amount, (Object)currencyIndex, (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                        }
                    }
                }
            } else if (args[1].equals("-notification")) {
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    builder.append(args[i]).append(' ');
                }
                String notification = builder.toString();
                if (args[2].equals("-all")) {
                    for (UUID playerUUID : OxygenHelperServer.getOnlinePlayersUUIDs()) {
                        EntityPlayerMP targetPlayerMP = CommonReference.playerByUUID(playerUUID);
                        if (targetPlayerMP == null) continue;
                        OxygenHelperServer.addNotification(targetPlayerMP, new SimpleNotification(0, notification, new String[0]));
                    }
                    if (sender instanceof EntityPlayerMP) {
                        senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.notification.sentTo", new Object[]{"ALL", notification}));
                    } else {
                        server.func_145747_a((ITextComponent)new TextComponentString(String.format("Notification sent to <all>: %s", notification)));
                    }
                    if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                        OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> sent notification to ALL: [{}].", (Object)sender.func_70005_c_(), (Object)notification);
                    }
                } else {
                    EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                    OxygenHelperServer.addNotification(targetPlayerMP, new SimpleNotification(0, notification, new String[0]));
                    if (sender instanceof EntityPlayerMP) {
                        senderPlayerMP.func_145747_a((ITextComponent)new TextComponentTranslation("oxygen_core.message.command.oxygenop.notification.sentTo", new Object[]{CommonReference.getName((Entity)targetPlayerMP), notification}));
                    } else {
                        server.func_145747_a((ITextComponent)new TextComponentString(String.format("Notification sent to <%s>: %s", CommonReference.getName((Entity)targetPlayerMP), notification)));
                    }
                    if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                        OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> sent notification to player {}/{}: [{}].", (Object)sender.func_70005_c_(), (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP), (Object)notification);
                    }
                }
            } else if (args[1].equals("-script")) {
                if (args[2].equals("-chat")) {
                    if (args.length >= 4) {
                        StringBuilder builder = new StringBuilder();
                        for (int i = 3; i < args.length; ++i) {
                            builder.append(args[i]).append(' ');
                        }
                        String scriptText = builder.toString();
                        if (this.shell == null) {
                            this.shell = ScriptingProvider.createShell(new Object[0]);
                        }
                        this.shell.put("sender", sender);
                        Object result = this.shell.evaluate(scriptText, String.format("script_%d", TimeHelperServer.getCurrentMillis()), true);
                        if (result != null) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Script executed. Result: %s", result)));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Script executed."));
                        }
                        if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                            OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> executed script from chat. Script text: {}", (Object)sender.func_70005_c_(), (Object)scriptText);
                        }
                    }
                } else if (args[2].equals("-file") && args.length == 4) {
                    ScriptWrapper scriptWrapper = null;
                    try {
                        scriptWrapper = ScriptWrapper.fromFile(CommonReference.getGameFolder() + "/config/oxygen/data/server/core/scripts/" + args[3], String.format("script_%d", TimeHelperServer.getCurrentMillis()));
                    }
                    catch (IOException exception) {
                        OxygenMain.LOGGER.error("Filed to load script file.");
                        exception.printStackTrace();
                    }
                    if (scriptWrapper != null) {
                        if (this.shell == null) {
                            this.shell = ScriptingProvider.createShell(new Object[0]);
                        }
                        this.shell.put("sender", sender);
                        Object result = this.shell.evaluate(scriptWrapper.getScriptText(), scriptWrapper.getName(), true);
                        if (result != null) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Script executed. Result: %s", result)));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Script executed."));
                        }
                        if (OxygenConfig.ADVANCED_LOGGING.asBoolean()) {
                            OxygenMain.LOGGER.info("[Core] (Operator/Console) <{}> executed script from file. Script name: {}, text: {}", (Object)sender.func_70005_c_(), (Object)args[3], (Object)scriptWrapper.getScriptText());
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Failed to load script file."));
                    }
                }
            }
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-privileges", "-currency", "-notification", "-script"});
        }
        if (args.length >= 3) {
            if (args[1].equals("-privileges")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-add-role", "-remove-role"});
            }
            if (args[1].equals("-currency")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-balance", "-set", "-add", "-remove"});
            }
            if (args[1].equals("-notification")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-all"});
            }
            if (args[1].equals("-script")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-chat", "-file"});
            }
        }
        return Collections.emptyList();
    }
}

