/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server;

import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.common.watcher.WatchedValue;
import austeretony.oxygen_core.server.WatchedValuesRegistryServer;
import austeretony.oxygen_core.server.api.CurrencyHelperServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.currency.CurrencyProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class CurrencyManagerServer {
    private CurrencyProvider commonProvider;
    private final Map<Integer, CurrencyProvider> providers = new HashMap<Integer, CurrencyProvider>(3);

    public void registerCurrencyProvider(CurrencyProvider provider) {
        if (provider.getIndex() == 0) {
            this.commonProvider = provider;
        }
        this.providers.put(provider.getIndex(), provider);
        WatchedValuesRegistryServer.registerWatchedValue(new WatchedValue(provider.getIndex(), 8, (playerUUID, value) -> value.setLong(CurrencyHelperServer.getCurrency(playerUUID, provider.getIndex()))));
    }

    public Collection<CurrencyProvider> getCurrencyProviders() {
        return this.providers.values();
    }

    public CurrencyProvider getCommonCurrencyProvider() {
        return this.commonProvider;
    }

    @Nullable
    public CurrencyProvider getCurrencyProvider(int index) {
        if (index == 0) {
            return this.commonProvider;
        }
        return this.providers.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrency(UUID playerUUID, int index) {
        UUID uUID = playerUUID;
        synchronized (uUID) {
            if (index == 0) {
                return this.commonProvider.getCurrency(playerUUID);
            }
            CurrencyProvider provider = this.providers.get(index);
            if (provider != null) {
                return provider.getCurrency(playerUUID);
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrency(UUID playerUUID, long value, int index) {
        UUID uUID = playerUUID;
        synchronized (uUID) {
            if (index == 0) {
                this.commonProvider.setCurrency(playerUUID, MathUtils.clamp(value, 0L, Long.MAX_VALUE));
                this.commonProvider.updated(playerUUID);
                OxygenHelperServer.setWatchedValueLong(playerUUID, index, value);
            } else {
                CurrencyProvider provider = this.providers.get(index);
                if (provider != null) {
                    provider.setCurrency(playerUUID, MathUtils.clamp(value, 0L, Long.MAX_VALUE));
                    provider.updated(playerUUID);
                    OxygenHelperServer.setWatchedValueLong(playerUUID, index, value);
                }
            }
        }
    }

    public boolean enoughCurrency(UUID playerUUID, long required, int index) {
        return this.getCurrency(playerUUID, index) >= required;
    }

    public void addCurrency(UUID playerUUID, long value, int index) {
        this.setCurrency(playerUUID, this.getCurrency(playerUUID, index) + value, index);
    }

    public void removeCurrency(UUID playerUUID, long value, int index) {
        this.setCurrency(playerUUID, this.getCurrency(playerUUID, index) - value, index);
    }
}

