/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.util;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.TimeHelperClient;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class OxygenUtils {
    public static String formattingCode(TextFormatting enumFormatting) {
        return enumFormatting.func_96297_d();
    }

    public static TextFormatting formattingFromCode(String code) {
        return TextFormatting.func_96300_b((String)code);
    }

    public static String formatCurrencyValue(String input) {
        int index = 1;
        StringBuilder builder = new StringBuilder();
        for (char c : new StringBuilder(input).reverse().toString().toCharArray()) {
            builder.append(c);
            if (index % 3 == 0 && index != input.length()) {
                builder.append(',');
            }
            ++index;
        }
        return builder.reverse().toString();
    }

    public static String formatDecimalCurrencyValue(String input) {
        int index = 1;
        StringBuilder builder = new StringBuilder();
        String[] array = input.split("[.]");
        for (char c : new StringBuilder(array[0]).reverse().toString().toCharArray()) {
            builder.append(c);
            if (index % 3 == 0 && index != array[0].length()) {
                builder.append(',');
            }
            ++index;
        }
        if (array.length == 2) {
            return builder.reverse().append('.').append(array[1]).toString();
        }
        return builder.reverse().toString();
    }

    public static String getTimePassedLocalizedString(long epochMilli) {
        if (epochMilli > 0L) {
            ZonedDateTime currentTime = TimeHelperClient.getZonedDateTime();
            ZonedDateTime timeStamp = TimeHelperClient.getZonedDateTime(epochMilli);
            long minutes = ChronoUnit.MINUTES.between(timeStamp, currentTime);
            long hours = ChronoUnit.HOURS.between(timeStamp, currentTime);
            long days = ChronoUnit.DAYS.between(timeStamp, currentTime);
            if (days > 0L) {
                if (days % 10L == 1L) {
                    return ClientReference.localize("oxygen_core.gui.day", days);
                }
                return ClientReference.localize("oxygen_core.gui.days", days);
            }
            if (hours > 0L) {
                if (hours % 10L == 1L) {
                    return ClientReference.localize("oxygen_core.gui.hour", hours);
                }
                return ClientReference.localize("oxygen_core.gui.hours", hours);
            }
            if (minutes % 10L == 1L) {
                return ClientReference.localize("oxygen_core.gui.minute", minutes);
            }
            return ClientReference.localize("oxygen_core.gui.minutes", minutes);
        }
        return ClientReference.localize("oxygen_core.gui.undef", new Object[0]);
    }

    public static String getExpirationTimeLocalizedString(long expiresInMilli, long epochMilli) {
        if (epochMilli > 0L) {
            ZonedDateTime currentTime = TimeHelperClient.getZonedDateTime();
            ZonedDateTime timeStamp = TimeHelperClient.getZonedDateTime(epochMilli);
            ZonedDateTime expireTime = TimeHelperClient.getZonedDateTime(epochMilli + expiresInMilli);
            Duration expirationDuration = Duration.between(timeStamp, expireTime);
            Duration timeLeftDuration = Duration.between(timeStamp, currentTime);
            Duration deltaDuration = expirationDuration.minus(timeLeftDuration);
            long minutes = deltaDuration.toMinutes();
            long hours = deltaDuration.toHours();
            long days = deltaDuration.toDays();
            if (minutes < 0L) {
                return ClientReference.localize("oxygen_core.gui.expired", new Object[0]);
            }
            if (days > 0L) {
                if (days % 10L == 1L) {
                    return ClientReference.localize("oxygen_core.gui.day", days);
                }
                return ClientReference.localize("oxygen_core.gui.days", days);
            }
            if (hours > 0L) {
                if (hours % 10L == 1L) {
                    return ClientReference.localize("oxygen_core.gui.hour", hours);
                }
                return ClientReference.localize("oxygen_core.gui.hours", hours);
            }
            if (minutes % 10L == 1L) {
                return ClientReference.localize("oxygen_core.gui.minute", minutes);
            }
            return ClientReference.localize("oxygen_core.gui.minutes", minutes);
        }
        return ClientReference.localize("oxygen_core.gui.undef", new Object[0]);
    }

    public static final Logger getLogger(String cat, String file, String name) {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%d{dd-MMM-yyyy HH:mm:ss}] [%t] [%c]: %m%n").withConfiguration(configuration).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setConfiguration(configuration)).withFileName("./logs/oxygen/" + cat + "/" + file + ".log").withFilePattern("./logs/oxygen/" + cat + "/" + file + "-%d{yyyy-MM-dd}.%i.log.gz").withName(name)).withAppend(true).withImmediateFlush(true)).withBufferedIo(true)).withBufferSize(8192)).withCreateOnDemand(false).withLocking(false).withLayout((Layout)layout)).withPolicy((TriggeringPolicy)CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{SizeBasedTriggeringPolicy.createPolicy((String)"10 M"), TimeBasedTriggeringPolicy.createPolicy((String)"1", null)})).withStrategy((RolloverStrategy)DefaultRolloverStrategy.createStrategy((String)"2147483647", (String)"1", (String)"max", (String)"0", null, (boolean)true, (Configuration)configuration)).build();
        appender.start();
        configuration.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)name, null, null);
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)true, (Level)Level.INFO, (String)name, (String)"true", (AppenderRef[])new AppenderRef[]{ref}, null, (Configuration)configuration, null);
        configuration.addLogger(name, loggerConfig);
        loggerContext.getLogger(name).addAppender((Appender)appender);
        loggerContext.updateLoggers();
        return loggerContext.getLogger(name);
    }
}

