/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.privilege;

import austeretony.oxygen_core.common.EnumValueType;
import austeretony.oxygen_core.common.privilege.EnumPrivilegeFileKey;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.PrivilegeImpl;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.value.TypedValueBoolean;
import austeretony.oxygen_core.common.value.TypedValueFloat;
import austeretony.oxygen_core.common.value.TypedValueInteger;
import austeretony.oxygen_core.common.value.TypedValueLong;
import austeretony.oxygen_core.common.value.TypedValueString;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;

public class PrivilegeUtils {
    public static Privilege getPrivilege(int id, boolean value) {
        return new PrivilegeImpl<TypedValueBoolean>(new TypedValueBoolean(value), id);
    }

    public static Privilege getPrivilege(int id, int value) {
        return new PrivilegeImpl<TypedValueInteger>(new TypedValueInteger(value), id);
    }

    public static Privilege getPrivilege(int id, long value) {
        return new PrivilegeImpl<TypedValueLong>(new TypedValueLong(value), id);
    }

    public static Privilege getPrivilege(int id, float value) {
        return new PrivilegeImpl<TypedValueFloat>(new TypedValueFloat(value), id);
    }

    public static Privilege getPrivilege(int id, String value) {
        return new PrivilegeImpl<TypedValueString>(new TypedValueString(value), id);
    }

    @Nullable
    public static Privilege fromJson(JsonObject jsonObject) {
        EnumValueType type = EnumValueType.values()[jsonObject.get(EnumPrivilegeFileKey.TYPE.name).getAsInt()];
        int id = jsonObject.get(EnumPrivilegeFileKey.ID.name).getAsInt();
        switch (type) {
            case BOOLEAN: {
                return new PrivilegeImpl<TypedValueBoolean>(new TypedValueBoolean(jsonObject.get(EnumPrivilegeFileKey.VALUE.name).getAsBoolean()), id);
            }
            case INT: {
                return new PrivilegeImpl<TypedValueInteger>(new TypedValueInteger(jsonObject.get(EnumPrivilegeFileKey.VALUE.name).getAsInt()), id);
            }
            case LONG: {
                return new PrivilegeImpl<TypedValueLong>(new TypedValueLong(jsonObject.get(EnumPrivilegeFileKey.VALUE.name).getAsLong()), id);
            }
            case FLOAT: {
                return new PrivilegeImpl<TypedValueFloat>(new TypedValueFloat(jsonObject.get(EnumPrivilegeFileKey.VALUE.name).getAsFloat()), id);
            }
            case STRING: {
                return new PrivilegeImpl<TypedValueString>(new TypedValueString(jsonObject.get(EnumPrivilegeFileKey.VALUE.name).getAsString()), id);
            }
        }
        return null;
    }

    @Nullable
    public static Privilege read(ByteBuf buffer) {
        short id = buffer.readShort();
        switch (EnumValueType.values()[buffer.readByte()]) {
            case BOOLEAN: {
                return new PrivilegeImpl<TypedValueBoolean>(new TypedValueBoolean(buffer.readBoolean()), id);
            }
            case INT: {
                return new PrivilegeImpl<TypedValueInteger>(new TypedValueInteger(buffer.readInt()), id);
            }
            case LONG: {
                return new PrivilegeImpl<TypedValueLong>(new TypedValueLong(buffer.readLong()), id);
            }
            case FLOAT: {
                return new PrivilegeImpl<TypedValueFloat>(new TypedValueFloat(buffer.readFloat()), id);
            }
            case STRING: {
                return new PrivilegeImpl<TypedValueString>(new TypedValueString(ByteBufUtils.readString(buffer)), id);
            }
        }
        return null;
    }
}

