/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.persistent;

import austeretony.oxygen_core.common.concurrent.OxygenExecutionManager;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.persistent.PersistentData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Future;

public class OxygenIOManager {
    private final OxygenExecutionManager executionManager;

    public OxygenIOManager(OxygenExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    public void loadPersistentData(PersistentData data) {
        String pathStr = data.getPath();
        Path path = Paths.get(pathStr, new String[0]);
        data.setChanged(false);
        data.reset();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(pathStr));){
                data.read(bis);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Persistent data <{}> loading failed. Path: {}", (Object)data.getDisplayName(), (Object)pathStr);
                exception.printStackTrace();
            }
        }
    }

    public Future<?> loadPersistentDataAsync(PersistentData data) {
        return this.executionManager.addIOTask(() -> this.loadPersistentData(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePersistentData(PersistentData data) {
        String pathStr = data.getPath();
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to create directoy. Path: {}", (Object)pathStr);
                exception.printStackTrace();
            }
        }
        PersistentData persistentData = data;
        synchronized (persistentData) {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(pathStr));){
                data.write(bos);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Persistent data <{}> saving failed. Path: {}", (Object)data.getDisplayName(), (Object)pathStr);
                exception.printStackTrace();
            }
        }
    }

    public Future<?> savePersistentDataAsync(PersistentData data) {
        return this.executionManager.addIOTask(() -> this.savePersistentData(data));
    }
}

