/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPRolePrivilegeOperation
extends Packet {
    private int ordinal;
    private int roleId;
    private int privilegeId;
    private String value;

    public SPRolePrivilegeOperation() {
    }

    public SPRolePrivilegeOperation(EnumOperation action, int roleId, int privilegeId, String value) {
        this.ordinal = action.ordinal();
        this.roleId = roleId;
        this.privilegeId = privilegeId;
        this.value = value;
    }

    @Override
    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeByte(this.roleId);
        buffer.writeShort(this.privilegeId);
        ByteBufUtils.writeString(this.value, buffer);
    }

    @Override
    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPRolePrivilegeOperation.getEntityPlayerMP(netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable(CommonReference.getPersistentUUID((Entity)playerMP), 4) && (ordinal = buffer.readByte()) >= 0 && ordinal < EnumOperation.values().length) {
            byte roleId = buffer.readByte();
            short privilegeId = buffer.readShort();
            String value = ByteBufUtils.readString(buffer);
            switch (EnumOperation.values()[ordinal]) {
                case ADD: {
                    OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getPrivilegesManager().addPrivilege(playerMP, roleId, privilegeId, value));
                    break;
                }
                case REMOVE: {
                    OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getPrivilegesManager().removePrivilege(playerMP, roleId, privilegeId));
                }
            }
        }
    }

    public static enum EnumOperation {
        ADD,
        REMOVE;

    }
}

