/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPRoleOperation
extends Packet {
    private int ordinal;
    private int roleId;
    private int roleNameColor;
    private int prefixColor;
    private int usernameColor;
    private int chatColor;
    private String roleName;
    private String prefix;

    public SPRoleOperation() {
    }

    public SPRoleOperation(EnumOperation action, int roleId, String roleName, String prefix, int roleNameColor, int prefixColor, int usernameColor, int chatColor) {
        this.ordinal = action.ordinal();
        this.roleId = roleId;
        this.roleName = roleName;
        this.prefix = prefix;
        this.roleNameColor = roleNameColor;
        this.prefixColor = prefixColor;
        this.usernameColor = usernameColor;
        this.chatColor = chatColor;
    }

    @Override
    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeByte(this.roleId);
        ByteBufUtils.writeString(this.roleName, buffer);
        ByteBufUtils.writeString(this.prefix, buffer);
        buffer.writeByte(this.roleNameColor);
        buffer.writeByte(this.prefixColor);
        buffer.writeByte(this.usernameColor);
        buffer.writeByte(this.chatColor);
    }

    @Override
    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPRoleOperation.getEntityPlayerMP(netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable(CommonReference.getPersistentUUID((Entity)playerMP), 4) && (ordinal = buffer.readByte()) >= 0 && ordinal < EnumOperation.values().length) {
            byte roleId = buffer.readByte();
            String roleName = ByteBufUtils.readString(buffer);
            String prefix = ByteBufUtils.readString(buffer);
            byte roleNameColor = buffer.readByte();
            byte prefixColor = buffer.readByte();
            byte usernameColor = buffer.readByte();
            byte chatColor = buffer.readByte();
            switch (EnumOperation.values()[ordinal]) {
                case CREATE: {
                    OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getPrivilegesManager().createRole(playerMP, roleId, roleName, prefix, roleNameColor, prefixColor, usernameColor, chatColor));
                    break;
                }
                case EDIT: {
                    OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getPrivilegesManager().editRole(playerMP, roleId, roleName, prefix, roleNameColor, prefixColor, usernameColor, chatColor));
                }
            }
        }
    }

    public static enum EnumOperation {
        CREATE,
        EDIT;

    }
}

