/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.inventory;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.inventory.PlayerInventoryProvider;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class VanillaPlayerInventoryProvider
implements PlayerInventoryProvider {
    @Override
    public int getSize(EntityPlayer player) {
        return player.field_71071_by.field_70462_a.size();
    }

    @Override
    public boolean isEmpty(EntityPlayer player) {
        return player.field_71071_by.field_70462_a.isEmpty();
    }

    @Override
    public int getEmptySlotsAmount(EntityPlayer player) {
        int empty = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (!itemStack.func_190926_b()) continue;
            ++empty;
        }
        return empty;
    }

    @Override
    public int getOccupiedSlotsAmount(EntityPlayer player) {
        int occupied = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            ++occupied;
        }
        return occupied;
    }

    @Override
    public int getEqualItemAmount(EntityPlayer player, ItemStackWrapper stackWrapper) {
        int amount = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (!stackWrapper.isEquals(itemStack)) continue;
            amount += itemStack.func_190916_E();
        }
        return amount;
    }

    @Override
    public boolean haveEnoughSpace(EntityPlayer player, ItemStackWrapper stackWrapper, int amount) {
        int slotsNeed;
        int maxStackSize = stackWrapper.getItemStack().func_77976_d();
        int emptySlots = this.getEmptySlotsAmount(player);
        if (emptySlots >= (slotsNeed = VanillaPlayerInventoryProvider.getSlotsForAmount(amount, maxStackSize))) {
            return true;
        }
        if (amount < maxStackSize) {
            int stored = this.getEqualItemAmount(player, stackWrapper);
            int modStored = stored % maxStackSize;
            return stored != 0 && amount + modStored <= maxStackSize;
        }
        return false;
    }

    @Override
    public void addItem(EntityPlayer player, ItemStackWrapper stackWrapper, int amount) {
        Runnable task = () -> {
            ItemStack itemStack = stackWrapper.getItemStack();
            int maxStackSize = itemStack.func_77976_d();
            if (amount <= maxStackSize) {
                itemStack.func_190920_e(amount);
                player.field_71071_by.func_70441_a(itemStack);
            } else {
                int i;
                for (i = amount; i >= maxStackSize; i -= maxStackSize) {
                    ItemStack resultStack = itemStack.func_77946_l();
                    resultStack.func_190920_e(maxStackSize);
                    player.field_71071_by.func_70441_a(resultStack);
                }
                if (i > 0) {
                    itemStack.func_190920_e(i);
                    player.field_71071_by.func_70441_a(itemStack);
                }
            }
        };
        if (player.field_70170_p.field_72995_K) {
            ClientReference.delegateToClientThread(task);
        } else {
            CommonReference.delegateToServerThread(task);
        }
    }

    @Override
    public void removeItem(EntityPlayer player, ItemStackWrapper stackWrapper, int amount) {
        Runnable task = () -> {
            int i = amount;
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                if (!stackWrapper.isEquals(itemStack)) continue;
                int stackSize = itemStack.func_190916_E();
                if (stackSize >= i) {
                    itemStack.func_190918_g(i);
                    break;
                }
                i -= stackSize;
                itemStack.func_190918_g(stackSize);
            }
        };
        if (player.field_70170_p.field_72995_K) {
            ClientReference.delegateToClientThread(task);
        } else {
            CommonReference.delegateToServerThread(task);
        }
    }

    @Override
    public Map<ItemStackWrapper, Integer> getInventoryContent(EntityPlayer player) {
        LinkedHashMap<ItemStackWrapper, Integer> contentMap = new LinkedHashMap<ItemStackWrapper, Integer>(this.getSize(player));
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            ItemStackWrapper stackWrapper = ItemStackWrapper.of(itemStack);
            if (!contentMap.containsKey(stackWrapper)) {
                contentMap.put(stackWrapper, itemStack.func_190916_E());
                continue;
            }
            int amount = (Integer)contentMap.get(stackWrapper);
            contentMap.put(stackWrapper, amount += itemStack.func_190916_E());
        }
        return contentMap;
    }

    @Override
    public void clear(EntityPlayer player) {
        player.field_71071_by.func_174888_l();
    }

    public static int getSlotsForAmount(int amount, int maxStackSize) {
        return amount / maxStackSize + (amount % maxStackSize == 0 ? 0 : 1);
    }
}

