/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.config;

import austeretony.oxygen_core.common.config.Config;
import austeretony.oxygen_core.common.config.OxygenConfig;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncConfigs;
import austeretony.oxygen_core.common.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;

public final class ConfigManager {
    private static ConfigManager instance;
    private final List<Config> configs = new ArrayList<Config>();
    private final ByteBuf compressedConfigs = Unpooled.buffer();

    private ConfigManager() {
    }

    public static void create() {
        if (instance == null) {
            instance = new ConfigManager();
        }
    }

    public static ConfigManager instance() {
        return instance;
    }

    public void registerConfig(Config config) {
        this.configs.add(config);
    }

    public void loadConfigs() {
        for (Config config : this.configs) {
            JsonObject configObject;
            Path path = Paths.get(config.getExternalPath(), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    configObject = JsonUtils.getExternalJsonData(config.getExternalPath()).getAsJsonObject();
                    configObject.add("version", (JsonElement)new JsonPrimitive(config.getVersion()));
                    if (config.load(configObject)) {
                        JsonUtils.createExternalJsonFile(config.getExternalPath(), (JsonElement)configObject);
                    }
                    config.write(this.compressedConfigs);
                    OxygenMain.LOGGER.info("[Core] Loaded config for <{}>.", (Object)config.getDomain());
                }
                catch (IOException | NullPointerException exception) {
                    OxygenMain.LOGGER.error("[Core] Config file for <{}> damaged!", (Object)config.getDomain(), (Object)exception);
                }
                continue;
            }
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                configObject = new JsonObject();
                configObject.add("version", (JsonElement)new JsonPrimitive(config.getVersion()));
                config.save(configObject);
                config.write(this.compressedConfigs);
                JsonUtils.createExternalJsonFile(config.getExternalPath(), (JsonElement)configObject);
                OxygenMain.LOGGER.info("[Core] Created config for <{}>.", (Object)config.getDomain());
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to create config for <>!", (Object)config.getDomain());
                exception.printStackTrace();
            }
        }
    }

    public void syncConfigs(EntityPlayerMP playerMP) {
        if (OxygenConfig.SYNC_CONFIGS.asBoolean()) {
            OxygenMain.network().sendTo(new CPSyncConfigs(this.compressedConfigs), playerMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfigs(ByteBuf buffer) {
        try {
            for (Config config : this.configs) {
                config.read(buffer);
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }
}

