/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.command;

import austeretony.oxygen_core.common.command.ArgumentExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractOxygenCommand
extends CommandBase {
    public final String commandName;
    public final Set<ArgumentExecutor> executors = new HashSet<ArgumentExecutor>(10);

    public AbstractOxygenCommand(String commandName) {
        this.commandName = commandName;
        this.getArgumentExecutors(this.executors);
    }

    public abstract void getArgumentExecutors(Set<ArgumentExecutor> var1);

    public String func_71517_b() {
        return this.commandName;
    }

    public String func_71518_a(ICommandSender sender) {
        return String.format("/%s <arg> (params...)", this.commandName);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return this.valid(server, sender);
    }

    public abstract boolean valid(MinecraftServer var1, ICommandSender var2);

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.executors.isEmpty() && args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        ArgumentExecutor executor = this.findExecutor(args[0]);
        if (executor == null) {
            throw new CommandException("oxygen_core.command.exception.wrongArg", new Object[]{args[0]});
        }
        executor.process(server, sender, args);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArgumentExecutor executor;
        if (args.length == 1) {
            return AbstractOxygenCommand.func_175762_a((String[])args, (Collection)this.executors.stream().map(ArgumentExecutor::getName).collect(Collectors.toList()));
        }
        if (args.length > 1 && (executor = this.findExecutor(args[0])) != null) {
            return executor.getTabCompletions(server, sender, args, targetPos);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected ArgumentExecutor findExecutor(String arg) {
        for (ArgumentExecutor executor : this.executors) {
            if (!executor.getName().equals(arg)) continue;
            return executor;
        }
        return null;
    }
}

