/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.api;

import austeretony.oxygen_core.common.util.DefaultTeleporter;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class CommonReference {
    public static String getGameFolder() {
        return ((File)FMLInjectionData.data()[6]).getAbsolutePath();
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static void registerEvent(Object event) {
        MinecraftForge.EVENT_BUS.register(event);
    }

    public static void registerCommand(FMLServerStartingEvent event, ICommand command) {
        event.registerServerCommand(command);
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static void sendChatMessage(EntityPlayer player, ITextComponent textComponent) {
        player.func_145747_a(textComponent);
    }

    public static UUID getPersistentUUID(Entity entity) {
        return entity.getPersistentID();
    }

    public static String getName(Entity entity) {
        return entity.func_70005_c_();
    }

    public static EntityPlayerMP playerByUUID(UUID playerUUID) {
        return CommonReference.getServer().func_184103_al().func_177451_a(playerUUID);
    }

    public static EntityPlayerMP playerByUsername(String username) {
        return CommonReference.getServer().func_184103_al().func_152612_a(username);
    }

    public static int getEntityId(Entity entity) {
        return entity.func_145782_y();
    }

    public static Entity getEntityById(Entity reference, int entityId) {
        return reference.field_70170_p.func_73045_a(entityId);
    }

    public static boolean isEntitiesNear(Entity first, Entity second, double range) {
        return first.func_70068_e(second) <= range * range;
    }

    public static void teleportPlayer(EntityPlayerMP playerMP, int dimension, double x, double y, double z, float yaw, float pitch) {
        playerMP.field_70177_z = playerMP.field_70759_as = yaw;
        playerMP.field_70125_A = pitch;
        CommonReference.teleportPlayer(playerMP, dimension, x, y, z);
    }

    public static void teleportPlayer(EntityPlayerMP playerMP, int dimension, double x, double y, double z) {
        if (playerMP.field_71093_bK == dimension) {
            playerMP.func_70634_a(x, y, z);
        } else {
            CommonReference.transferToDimension(playerMP, dimension, x, y, z);
        }
    }

    public static void transferToDimension(EntityPlayerMP playerMP, int dimension, double x, double y, double z) {
        int currDimension = playerMP.field_71093_bK;
        WorldServer worldServer = CommonReference.getServer().func_71218_a(currDimension);
        worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(playerMP, dimension, (Teleporter)new DefaultTeleporter(worldServer, x, y, z));
        playerMP.func_70634_a(x, y, z);
        if (currDimension == 1) {
            worldServer.func_72838_d((Entity)playerMP);
            worldServer.func_72866_a((Entity)playerMP, false);
        }
    }

    public static ListenableFuture<?> delegateToServerThread(Runnable task) {
        return CommonReference.getServer().func_152344_a(task);
    }
}

