/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.util;

import austeretony.oxygen_core.client.api.ClientReference;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ScreenshotHelper {
    public static BufferedImage createScreenshot(int width, int height) {
        return ScreenshotHelper.resize(ScreenshotHelper.prepareImage(ClientReference.getMinecraft().field_71443_c, ClientReference.getMinecraft().field_71440_d, ClientReference.getMinecraft().func_147110_a()), width, height);
    }

    public static BufferedImage prepareImage(int width, int height, Framebuffer frameBuffer) {
        if (OpenGlHelper.func_148822_b()) {
            width = frameBuffer.field_147622_a;
            height = frameBuffer.field_147620_b;
        }
        int i = width * height;
        Buffer pixelBuffer = null;
        int[] pixelValues = null;
        if (pixelBuffer == null || pixelBuffer.capacity() < i) {
            pixelBuffer = BufferUtils.createIntBuffer((int)i);
            pixelValues = new int[i];
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        ((IntBuffer)pixelBuffer).clear();
        if (OpenGlHelper.func_148822_b()) {
            GL11.glBindTexture((int)3553, (int)frameBuffer.field_147617_g);
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        } else {
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        }
        ((IntBuffer)pixelBuffer).get(pixelValues);
        ScreenshotHelper.processPixelValues(pixelValues, width, height);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        bufferedImage.setRGB(0, 0, width, height, pixelValues, 0, width);
        return bufferedImage;
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int newWidth, int newHeight) {
        BufferedImage resizedImage = new BufferedImage(newWidth, newHeight, 1);
        int oldWidth = bufferedImage.getWidth();
        int oldHeight = bufferedImage.getHeight();
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int color = bufferedImage.getRGB(x * oldWidth / newWidth, y * oldHeight / newHeight);
                resizedImage.setRGB(x, y, color);
            }
        }
        return resizedImage;
    }

    public static void processPixelValues(int[] values, int width, int height) {
        int[] aint = new int[width];
        int i = height / 2;
        for (int j = 0; j < i; ++j) {
            System.arraycopy(values, j * width, aint, 0, width);
            System.arraycopy(values, (height - 1 - j) * width, values, j * width, width);
            System.arraycopy(aint, 0, values, (height - 1 - j) * width, width);
        }
    }
}

