/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.preset;

import austeretony.oxygen_core.client.preset.PresetClient;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public abstract class AbstractPresetClient
implements PresetClient {
    private long versionId;

    @Override
    public long getVersionId() {
        return this.versionId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadVersionId(String folder) {
        this.versionId = 0L;
        String pathStr = folder + this.getName() + "_version.txt";
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) return false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pathStr));){
            this.versionId = Long.parseLong(bufferedReader.readLine());
            boolean bl = true;
            return bl;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean save(String folder) {
        boolean successful = this.saveToFolder(folder);
        if (successful) {
            return this.saveVersionId(folder);
        }
        return false;
    }

    public abstract boolean saveToFolder(String var1);

    private boolean saveVersionId(String folder) {
        String idPathStr = folder + this.getName() + "_version.txt";
        Path idPath = Paths.get(idPathStr, new String[0]);
        try {
            Files.createDirectories(idPath.getParent(), new FileAttribute[0]);
            try (PrintStream printStream = new PrintStream(new File(idPathStr));){
                printStream.println(this.versionId);
            }
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public void read(ByteBuf buffer) {
        this.reset();
        this.versionId = buffer.readLong();
        this.readFromBuf(buffer);
    }

    public abstract void reset();

    public abstract void readFromBuf(ByteBuf var1);
}

