/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.instant;

import austeretony.oxygen_core.client.instant.InstantDataContainer;
import austeretony.oxygen_core.common.instant.InstantData;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InstantDataManagerClient {
    private final Map<Integer, InstantData> registry = new HashMap<Integer, InstantData>();
    private final Map<Integer, InstantDataContainer> containers = new ConcurrentHashMap<Integer, InstantDataContainer>();

    public void registerInstantData(InstantData data) {
        this.registry.put(data.getIndex(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataReceived(ByteBuf buffer) {
        try {
            int amount = buffer.readShort();
            for (int i = 0; i < amount; ++i) {
                int entityId = buffer.readInt();
                if (entityId == -1) continue;
                InstantDataContainer container = this.getInstantDataContainer(entityId);
                for (int j = 0; j < this.registry.size(); ++j) {
                    byte index = buffer.readByte();
                    if (index == -1) continue;
                    container.get(index).read(buffer);
                }
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    public InstantDataContainer getInstantDataContainer(int entityId) {
        InstantDataContainer container = this.containers.get(entityId);
        if (container == null) {
            container = new InstantDataContainer();
            for (InstantData data : this.registry.values()) {
                container.init(data.getIndex(), data.copy());
            }
            this.containers.put(entityId, container);
        }
        return container;
    }

    public InstantData getInstantData(int entityId, int index) {
        return this.getInstantDataContainer(entityId).get(index);
    }
}

