/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.settings.gui.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenNumberField;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.elements.OxygenTexturedButton;
import austeretony.oxygen_core.client.gui.settings.GUISettingsSection;
import austeretony.oxygen_core.client.gui.settings.SettingsScreen;
import austeretony.oxygen_core.client.gui.settings.gui.OffsetButton;

public class SetOffsetCallback
extends AbstractGUICallback {
    private final SettingsScreen screen;
    private final GUISettingsSection section;
    private OxygenNumberField offsetField;
    private OxygenTexturedButton applyButton;
    private OxygenTexturedButton resetButton;
    private OxygenKeyButton confirmButton;
    private OxygenKeyButton cancelButton;
    private OffsetButton offsetButton;
    private String newOffsetStr;

    public SetOffsetCallback(SettingsScreen screen, GUISettingsSection section, int width, int height) {
        super(screen, section, width, height);
        this.screen = screen;
        this.section = section;
    }

    @Override
    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement(new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.settings.callback.setOffset", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.addElement(new OxygenTextLabel(6, 23, ClientReference.localize("oxygen_core.gui.settings.offset", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.offsetField = new OxygenNumberField(6, 25, 30, "", 200L, false, 0, false);
        this.addElement(this.offsetField);
        this.applyButton = new OxygenTexturedButton(40, 27, 5, 5, OxygenGUITextures.CHECK_ICONS, 5, 5, ClientReference.localize("oxygen_core.gui.apply", new Object[0]));
        this.addElement(this.applyButton);
        this.applyButton.setClickListener((mouseX, mouseY, mouseButton) -> this.applyOffset());
        this.resetButton = new OxygenTexturedButton(48, 27, 5, 5, OxygenGUITextures.CROSS_ICONS, 5, 5, ClientReference.localize("oxygen_core.gui.reset", new Object[0]));
        this.addElement(this.resetButton);
        this.resetButton.setClickListener((mouseX, mouseY, mouseButton) -> this.resetOffset());
        this.confirmButton = (OxygenKeyButton)new OxygenKeyButton(15, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.confirm", new Object[0]), 19, this::confirm).disable();
        this.addElement(this.confirmButton);
        this.cancelButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.cancel", new Object[0]), 45, this::close);
        this.addElement(this.cancelButton);
    }

    private void applyOffset() {
        this.newOffsetStr = this.offsetField.getTypedText();
        this.confirmButton.enable();
    }

    private void resetOffset() {
        this.newOffsetStr = this.offsetButton.offsetSetting.getUserValue();
        this.offsetField.setText(this.offsetButton.offsetSetting.getUserValue());
        this.confirmButton.enable();
    }

    @Override
    protected void onOpen() {
        this.offsetField.setText(this.offsetButton.offsetSetting.getUserValue());
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                this.confirm();
            }
        }
    }

    private void confirm() {
        this.offsetButton.offsetSetting.setValue(this.newOffsetStr);
        this.offsetButton.setDisplayText(this.offsetButton.offsetSetting.getUserValue());
        OxygenManagerClient.instance().getClientSettingManager().changed();
        this.confirmButton.disable();
        this.close();
    }

    public void open(OffsetButton button) {
        this.offsetButton = button;
        this.open();
    }
}

