/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.settings.gui.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenTextField;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.elements.OxygenTexturedButton;
import austeretony.oxygen_core.client.gui.settings.GUISettingsSection;
import austeretony.oxygen_core.client.gui.settings.SettingsScreen;
import austeretony.oxygen_core.client.gui.settings.gui.ColorButton;
import austeretony.oxygen_core.client.gui.settings.gui.ColorFrame;
import austeretony.oxygen_core.common.main.OxygenMain;

public class SetColorCallback
extends AbstractGUICallback {
    private final SettingsScreen screen;
    private final GUISettingsSection section;
    private OxygenTextField colorARGBField;
    private OxygenTexturedButton applyButton;
    private OxygenTexturedButton resetButton;
    private OxygenKeyButton confirmButton;
    private OxygenKeyButton cancelButton;
    private ColorFrame colorFrame;
    private ColorButton colorButton;
    private String newColorStr;

    public SetColorCallback(SettingsScreen screen, GUISettingsSection section, int width, int height) {
        super(screen, section, width, height);
        this.screen = screen;
        this.section = section;
    }

    @Override
    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement(new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 11, ClientReference.localize("oxygen_core.gui.settings.callback.setColor", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.addElement(new OxygenTextLabel(6, 23, ClientReference.localize("oxygen_core.gui.settings.argbColor", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.colorFrame = new ColorFrame(6, 25, -1);
        this.addElement(this.colorFrame);
        this.colorARGBField = new OxygenTextField(18, 25, 55, 8, "");
        this.addElement(this.colorARGBField);
        this.applyButton = new OxygenTexturedButton(78, 27, 5, 5, OxygenGUITextures.CHECK_ICONS, 5, 5, ClientReference.localize("oxygen_core.gui.apply", new Object[0]));
        this.addElement(this.applyButton);
        this.applyButton.setClickListener((mouseX, mouseY, mouseButton) -> this.applyColor());
        this.resetButton = new OxygenTexturedButton(86, 27, 5, 5, OxygenGUITextures.CROSS_ICONS, 5, 5, ClientReference.localize("oxygen_core.gui.reset", new Object[0]));
        this.addElement(this.resetButton);
        this.resetButton.setClickListener((mouseX, mouseY, mouseButton) -> this.resetColor());
        this.confirmButton = (OxygenKeyButton)new OxygenKeyButton(15, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.confirm", new Object[0]), 19, this::confirm).disable();
        this.addElement(this.confirmButton);
        this.cancelButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.cancel", new Object[0]), 45, this::close);
        this.addElement(this.cancelButton);
    }

    private void applyColor() {
        this.newColorStr = this.colorARGBField.getTypedText();
        try {
            this.colorFrame.setWarning(false);
            this.colorFrame.setColor((int)Long.parseLong(this.newColorStr, 16));
            this.confirmButton.enable();
        }
        catch (NumberFormatException exception) {
            OxygenMain.LOGGER.error("[Core] Invalid color value!", (Throwable)exception);
            this.colorFrame.setWarning(true);
        }
    }

    private void resetColor() {
        this.newColorStr = this.colorButton.colorSetting.getUserValue();
        this.colorARGBField.setText(this.colorButton.colorSetting.getUserValue());
        this.colorFrame.setColor(this.colorButton.colorSetting.asInt());
        this.confirmButton.enable();
    }

    @Override
    protected void onOpen() {
        this.colorFrame.setColor(this.colorButton.colorSetting.asInt());
        this.colorARGBField.setText(this.colorButton.colorSetting.getUserValue());
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                this.confirm();
            }
        }
    }

    private void confirm() {
        this.colorButton.colorSetting.setValue(this.newColorStr);
        this.colorButton.setButtonColor(this.colorButton.colorSetting.asInt());
        OxygenManagerClient.instance().getClientSettingManager().changed();
        this.confirmButton.disable();
        this.close();
    }

    public void open(ColorButton button) {
        this.colorButton = button;
        this.open();
    }
}

