/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.settings.gui;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenButton;
import austeretony.oxygen_core.common.settings.SettingValue;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import net.minecraft.client.renderer.GlStateManager;

public class ColorButton
extends GUISimpleElement<ColorButton> {
    private OxygenButton.ClickListener clickListener;
    public final SettingValue colorSetting;
    private int buttonColor;

    public ColorButton(int xPosition, int yPosition, SettingValue colorSetting, String tooltip) {
        this.setPosition(xPosition, yPosition);
        this.setSize(7, 7);
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.getSoundEvent());
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.BUTTON_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.BUTTON_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.BUTTON_HOVERED_COLOR.get().asInt());
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat());
        if (!tooltip.isEmpty()) {
            this.initTooltip(tooltip, EnumBaseGUISetting.TOOLTIP_TEXT_COLOR.get().asInt(), EnumBaseGUISetting.TOOLTIP_BACKGROUND_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        }
        this.colorSetting = colorSetting;
        this.buttonColor = colorSetting.asInt();
        this.enableFull();
    }

    public void setClickListener(OxygenButton.ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void setButtonColor(int buttonColor) {
        this.buttonColor = buttonColor;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && this.clickListener != null) {
            this.clickListener.mouseClick(mouseX, mouseY, mouseButton);
        }
        return flag;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered()) {
                color = this.getHoveredBackgroundColor();
            }
            ColorButton.drawRect(0, 0, this.getWidth(), this.getHeight(), this.buttonColor);
            OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, this.getHeight(), color);
            OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, 0.0, this.getWidth(), this.getHeight(), color);
            OxygenGUIUtils.drawRect(0.0, 0.0, this.getWidth(), 0.4, color);
            OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() - 0.4, this.getWidth(), this.getHeight(), color);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isHovered() && this.hasTooltip()) {
            int width = this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor()) + 6;
            int height = 9;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.getX() + this.getWidth() / 2 - width / 2), (float)(this.getY() - height - 2), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ColorButton.drawRect(0, 0, width, height, this.getTooltipBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, height, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect((double)width - 0.4, 0.0, width, height, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, width, 0.4, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, (double)height - 0.4, width, height, this.getStaticBackgroundColor());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((width - this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor())) / 2), (float)((height - this.textHeight(this.getTooltipScaleFactor())) / 2 + 1), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getTooltipText(), 0.0f, 0.0f, this.getTooltipTextColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }
}

