/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management.roles.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenNumberField;
import austeretony.oxygen_core.client.gui.elements.OxygenTextField;
import austeretony.oxygen_core.client.gui.elements.OxygenTextFormattingColorPicker;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegesManagementScreen;
import austeretony.oxygen_core.client.gui.privileges.management.RolesSection;
import austeretony.oxygen_core.common.config.PrivilegesConfig;
import net.minecraft.util.text.TextFormatting;

public class RoleCreationCallback
extends AbstractGUICallback {
    private final PrivilegesManagementScreen screen;
    private final RolesSection section;
    private OxygenTextLabel chatFormattingLabel;
    private OxygenTextField roleNameField;
    private OxygenTextField prefixField;
    private OxygenNumberField roleIdField;
    private OxygenTextFormattingColorPicker roleNameColorPicker;
    private OxygenTextFormattingColorPicker prefixColorPicker;
    private OxygenTextFormattingColorPicker usernameColorPicker;
    private OxygenTextFormattingColorPicker chatColorPicker;
    private OxygenKeyButton confirmButton;
    private OxygenKeyButton cancelButton;

    public RoleCreationCallback(PrivilegesManagementScreen screen, RolesSection section, int width, int height) {
        super(screen, section, width, height);
        this.screen = screen;
        this.section = section;
    }

    @Override
    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement(new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.privileges.management.callback.roleCreation", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.addElement(new OxygenTextLabel(6, 23, ClientReference.localize("oxygen_core.gui.privileges.management.callback.roleName", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.roleNameField = new OxygenTextField(6, 25, 80, 24, "");
        this.addElement(this.roleNameField);
        this.roleNameField.setInputListener((keyChar, keyCode) -> {
            OxygenKeyButton cfr_ignored_0 = (OxygenKeyButton)this.confirmButton.setEnabled(!this.roleNameField.getTypedText().isEmpty() && !this.roleIdField.getTypedText().isEmpty());
        });
        this.addElement(new OxygenTextLabel(6, 42, ClientReference.localize("oxygen_core.gui.privileges.management.callback.roleId", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.roleIdField = new OxygenNumberField(6, 44, 30, "", 127L, false, 0, true);
        this.addElement(this.roleIdField);
        this.roleIdField.setInputListener((keyChar, keyCode) -> {
            OxygenKeyButton cfr_ignored_0 = (OxygenKeyButton)this.confirmButton.setEnabled(!this.roleNameField.getTypedText().isEmpty() && !this.roleIdField.getTypedText().isEmpty());
        });
        this.addElement(new OxygenTextLabel(6, 61, ClientReference.localize("oxygen_core.gui.privileges.management.callback.prefix", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.prefixField = new OxygenTextField(6, 63, 80, 16, "");
        this.addElement(this.prefixField);
        this.addElement(new OxygenTextLabel(6, 81, ClientReference.localize("oxygen_core.gui.privileges.management.callback.roleNameColor", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.roleNameColorPicker = new OxygenTextFormattingColorPicker(6, 83);
        this.addElement(this.roleNameColorPicker);
        this.addElement(new OxygenTextLabel(6, 99, ClientReference.localize("oxygen_core.gui.privileges.management.callback.prefixColor", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.prefixColorPicker = new OxygenTextFormattingColorPicker(6, 101);
        this.addElement(this.prefixColorPicker);
        this.prefixColorPicker.setColorPickListener(index -> this.updateChatFormatting());
        this.addElement(new OxygenTextLabel(6, 117, ClientReference.localize("oxygen_core.gui.privileges.management.callback.usernameColor", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.usernameColorPicker = new OxygenTextFormattingColorPicker(6, 119);
        this.addElement(this.usernameColorPicker);
        this.usernameColorPicker.setColorPickListener(index -> this.updateChatFormatting());
        this.addElement(new OxygenTextLabel(6, 135, ClientReference.localize("oxygen_core.gui.privileges.management.callback.chatColor", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.chatColorPicker = new OxygenTextFormattingColorPicker(6, 137);
        this.addElement(this.chatColorPicker);
        this.chatColorPicker.setColorPickListener(index -> this.updateChatFormatting());
        this.addElement(new OxygenTextLabel(6, 154, ClientReference.localize("oxygen_core.gui.privileges.chatFormatting", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() + 0.05f, EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.chatFormattingLabel = new OxygenTextLabel(6, 162, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt());
        this.addElement(this.chatFormattingLabel);
        this.confirmButton = (OxygenKeyButton)new OxygenKeyButton(15, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.confirm", new Object[0]), 19, this::confirm).disable();
        this.addElement(this.confirmButton);
        this.cancelButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.cancel", new Object[0]), 45, this::close);
        this.addElement(this.cancelButton);
    }

    private void updateChatFormatting() {
        if (PrivilegesConfig.ENABLE_FORMATTED_CHAT.asBoolean()) {
            if (PrivilegesConfig.ENABLE_CUSTOM_FORMATTED_CHAT.asBoolean()) {
                String result;
                String prefix = null;
                TextFormatting defColor = TextFormatting.values()[PrivilegesConfig.DEFAULT_CHAT_COLOR.asInt()];
                if (!this.prefixField.getTypedText().isEmpty()) {
                    prefix = TextFormatting.values()[this.prefixColorPicker.getPickedColorIndex()] + this.prefixField.getTypedText() + TextFormatting.RESET;
                }
                String username = TextFormatting.values()[this.usernameColorPicker.getPickedColorIndex()] + ClientReference.getClientPlayer().func_70005_c_() + TextFormatting.RESET;
                String string = result = !this.prefixField.getTypedText().isEmpty() ? PrivilegesConfig.FORMATTED_CHAT_PREFIX_PATTERN.asString() : PrivilegesConfig.FORMATTED_CHAT_PATTERN.asString();
                if (prefix != null) {
                    result = defColor + result.replace("@prefix", prefix + defColor);
                }
                result = result.replace("@username", username + defColor);
                result = result + TextFormatting.values()[this.chatColorPicker.getPickedColorIndex()] + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0]);
                this.chatFormattingLabel.setDisplayText(result);
            } else {
                StringBuilder formattedUsername = new StringBuilder();
                if (!this.prefixField.getTypedText().isEmpty()) {
                    formattedUsername.append(TextFormatting.values()[this.prefixColorPicker.getPickedColorIndex()]);
                    formattedUsername.append("[");
                    formattedUsername.append(this.prefixField.getTypedText());
                    formattedUsername.append("]");
                    formattedUsername.append(TextFormatting.RESET);
                }
                formattedUsername.append(TextFormatting.values()[this.usernameColorPicker.getPickedColorIndex()]);
                formattedUsername.append(ClientReference.getClientPlayer().func_70005_c_());
                formattedUsername.append(TextFormatting.RESET);
                this.chatFormattingLabel.setDisplayText(ClientReference.localize("chat.type.text", formattedUsername.toString(), TextFormatting.values()[this.chatColorPicker.getPickedColorIndex()] + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0])));
            }
        } else {
            this.chatFormattingLabel.setDisplayText(ClientReference.localize("chat.type.text", ClientReference.getClientPlayer().func_70005_c_(), ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0])));
        }
    }

    @Override
    protected void onOpen() {
        this.roleNameField.reset();
        this.roleIdField.reset();
        this.prefixField.reset();
        this.roleNameColorPicker.setPickedColorIndex(TextFormatting.GRAY.ordinal());
        this.prefixColorPicker.setPickedColorIndex(TextFormatting.GRAY.ordinal());
        this.usernameColorPicker.setPickedColorIndex(TextFormatting.GRAY.ordinal());
        this.chatColorPicker.setPickedColorIndex(TextFormatting.GRAY.ordinal());
        this.updateChatFormatting();
    }

    private void confirm() {
        if (!(this.roleNameField.isDragged() || this.roleIdField.isDragged() || this.prefixField.isDragged())) {
            OxygenManagerClient.instance().getPrivilegesManager().createRoleSynced((int)this.roleIdField.getTypedNumberAsLong(), this.roleNameField.getTypedText(), this.prefixField.getTypedText(), this.roleNameColorPicker.getPickedColorIndex(), this.prefixColorPicker.getPickedColorIndex(), this.usernameColorPicker.getPickedColorIndex(), this.chatColorPicker.getPickedColorIndex());
            this.confirmButton.disable();
            this.close();
        }
    }

    @Override
    public void close() {
        if (!(this.roleNameField.isDragged() || this.roleIdField.isDragged() || this.prefixField.isDragged())) {
            super.close();
        }
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                this.confirm();
            }
        }
    }
}

