/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management.roles.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenNumberField;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenTextField;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegesManagementScreen;
import austeretony.oxygen_core.client.gui.privileges.management.RolesSection;
import austeretony.oxygen_core.client.gui.privileges.management.roles.callback.PrivilegePanelEntry;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.privilege.PrivilegeRegistry;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;

public class AddPrivilegeCallback
extends AbstractGUICallback {
    private final PrivilegesManagementScreen screen;
    private final RolesSection section;
    private OxygenNumberField privilegeIdField;
    private OxygenTextField valueField;
    private OxygenScrollablePanel privilegesPanel;
    private OxygenKeyButton confirmButton;
    private OxygenKeyButton cancelButton;
    private PrivilegePanelEntry currPrivilegeEntry;
    private String privilegeValue;

    public AddPrivilegeCallback(PrivilegesManagementScreen screen, RolesSection section, int width, int height) {
        super(screen, section, width, height);
        this.screen = screen;
        this.section = section;
    }

    @Override
    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement(new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.privileges.management.callback.addPrivilege", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.addElement(new OxygenTextLabel(6, 23, ClientReference.localize("oxygen_core.gui.privileges.privileges", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() + 0.05f, EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.privilegesPanel = new OxygenScrollablePanel(this.screen, 6, 26, this.getWidth() - 15, 10, 1, 1400, 7, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), false);
        this.addElement(this.privilegesPanel);
        this.loadPrivileges();
        this.privilegesPanel.setElementClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (previous != null) {
                previous.setToggled(false);
            }
            clicked.toggle();
            this.currPrivilegeEntry = clicked;
            this.confirmButton.setEnabled(!this.valueField.getTypedText().isEmpty());
        });
        this.addElement(new OxygenTextLabel(6, 112, ClientReference.localize("oxygen_core.gui.privileges.management.callback.privilegeId", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.privilegeIdField = new OxygenNumberField(6, 113, 50, "", 32767L, false, 0, true);
        this.addElement(this.privilegeIdField);
        this.privilegeIdField.setInputListener((keyChar, keyCode) -> {
            OxygenKeyButton cfr_ignored_0 = (OxygenKeyButton)this.confirmButton.setEnabled(!this.valueField.getTypedText().isEmpty());
        });
        this.addElement(new OxygenTextLabel(6, 131, ClientReference.localize("oxygen_core.gui.privileges.management.callback.value", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.valueField = new OxygenTextField(6, 132, 50, 10, "");
        this.addElement(this.valueField);
        this.valueField.setInputListener((keyChar, keyCode) -> this.validateInputValue());
        this.confirmButton = (OxygenKeyButton)new OxygenKeyButton(15, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.confirm", new Object[0]), 19, this::confirm).disable();
        this.addElement(this.confirmButton);
        this.cancelButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.cancel", new Object[0]), 45, this::close);
        this.addElement(this.cancelButton);
    }

    private void loadPrivileges() {
        ArrayList<PrivilegeRegistry.PrivilegeRegistryEntry> entries = new ArrayList<PrivilegeRegistry.PrivilegeRegistryEntry>(PrivilegeRegistry.getRegisteredPrivileges());
        Collections.sort(entries, (e1, e2) -> e1.id - e2.id);
        this.privilegesPanel.reset();
        for (PrivilegeRegistry.PrivilegeRegistryEntry entry : entries) {
            this.privilegesPanel.addEntry(new PrivilegePanelEntry(entry));
        }
        this.privilegesPanel.getScroller().reset();
        this.privilegesPanel.getScroller().updateRowsAmount(MathUtils.clamp(entries.size(), 7, 1400));
    }

    private void validateInputValue() {
        PrivilegeRegistry.PrivilegeRegistryEntry entry;
        PrivilegeRegistry.PrivilegeRegistryEntry privilegeRegistryEntry = entry = this.currPrivilegeEntry != null ? (PrivilegeRegistry.PrivilegeRegistryEntry)this.currPrivilegeEntry.getWrapped() : PrivilegeRegistry.getRegistryEntry((int)this.privilegeIdField.getTypedNumberAsLong());
        if (entry != null) {
            this.privilegeValue = this.valueField.getTypedText();
            boolean valid = false;
            switch (entry.type) {
                case INT: {
                    try {
                        int value = Integer.parseInt(this.privilegeValue);
                        valid = true;
                    }
                    catch (NumberFormatException exception) {
                        OxygenMain.LOGGER.error("[Core] Wrong privilege integer value!");
                    }
                    break;
                }
                case FLOAT: {
                    try {
                        float value = Float.parseFloat(this.privilegeValue);
                        valid = true;
                    }
                    catch (NumberFormatException exception) {
                        OxygenMain.LOGGER.error("[Core] Wrong privilege float value!");
                    }
                    break;
                }
                case LONG: {
                    try {
                        long value = Long.parseLong(this.privilegeValue);
                        valid = true;
                    }
                    catch (NumberFormatException exception) {
                        OxygenMain.LOGGER.error("[Core] Wrong privilege long value!");
                    }
                    break;
                }
                default: {
                    valid = true;
                }
            }
            this.confirmButton.setEnabled(valid);
        }
    }

    @Override
    protected void onOpen() {
        if (this.currPrivilegeEntry != null) {
            this.currPrivilegeEntry.setToggled(false);
        }
        this.currPrivilegeEntry = null;
        this.privilegeIdField.reset();
        this.valueField.reset();
        this.confirmButton.disable();
    }

    private void confirm() {
        if (!this.valueField.isDragged()) {
            OxygenManagerClient.instance().getPrivilegesManager().addPrivilegeSynced(((Role)this.section.getCurrentRoleEntry().getWrapped()).getId(), this.privilegeIdField.getTypedText().isEmpty() ? ((PrivilegeRegistry.PrivilegeRegistryEntry)this.currPrivilegeEntry.getWrapped()).id : (int)this.privilegeIdField.getTypedNumberAsLong(), this.privilegeValue);
            this.confirmButton.disable();
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.valueField.isDragged()) {
            super.close();
        }
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                this.confirm();
            }
        }
    }
}

