/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management.players.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.privileges.management.PlayersSection;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegesManagementScreen;
import austeretony.oxygen_core.client.gui.privileges.management.players.PlayerRolePanelEntry;
import austeretony.oxygen_core.common.PlayerSharedData;
import java.util.UUID;

public class RemovePlayerRoleCallback
extends AbstractGUICallback {
    private final PrivilegesManagementScreen screen;
    private final PlayersSection section;
    private OxygenScrollablePanel rolesPanel;
    private OxygenKeyButton closeButton;

    public RemovePlayerRoleCallback(PrivilegesManagementScreen screen, PlayersSection section, int width, int height) {
        super(screen, section, width, height);
        this.screen = screen;
        this.section = section;
    }

    @Override
    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement(new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.privileges.management.callback.removePlayerRole", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.addElement(new OxygenTextLabel(6, 23, ClientReference.localize("oxygen_core.gui.privileges.roles", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() + 0.05f, EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.rolesPanel = new OxygenScrollablePanel(this.screen, 6, 26, this.getWidth() - 15, 10, 1, 5, 5, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), false);
        this.addElement(this.rolesPanel);
        this.closeButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.close", new Object[0]), 45, this::close);
        this.addElement(this.closeButton);
    }

    private void loadPlayerRoles() {
        this.rolesPanel.reset();
        PlayerSharedData sharedData = OxygenManagerClient.instance().getPrivilegesContainer().getServerPlayerData((UUID)this.section.getCurrentPlayerEntry().getWrapped());
        for (int i = 0; i < 5; ++i) {
            int roleId = sharedData.getByte(i + 10);
            if (roleId == -1) continue;
            this.rolesPanel.addEntry(new PlayerRolePanelEntry(OxygenManagerClient.instance().getPrivilegesContainer().getServerRole(roleId), (UUID)this.section.getCurrentPlayerEntry().getWrapped()));
        }
    }

    @Override
    protected void onOpen() {
        this.loadPlayerRoles();
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.closeButton) {
            this.close();
        }
    }
}

