/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management.players.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenPanelEntry;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.privileges.management.PlayersSection;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegesManagementScreen;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;

public class AddPlayerRoleCallback
extends AbstractGUICallback {
    private final PrivilegesManagementScreen screen;
    private final PlayersSection section;
    private OxygenScrollablePanel rolesPanel;
    private OxygenKeyButton confirmButton;
    private OxygenKeyButton cancelButton;
    private OxygenPanelEntry<Integer> currRoleEntry;

    public AddPlayerRoleCallback(PrivilegesManagementScreen screen, PlayersSection section, int width, int height) {
        super(screen, section, width, height);
        this.screen = screen;
        this.section = section;
    }

    @Override
    public void init() {
        this.enableDefaultBackground(EnumBaseGUISetting.FILL_CALLBACK_COLOR.get().asInt());
        this.addElement(new OxygenCallbackBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.privileges.management.callback.addPlayerRole", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.rolesPanel = new OxygenScrollablePanel(this.screen, 6, 16, this.getWidth() - 15, 10, 1, 140, 7, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), false);
        this.addElement(this.rolesPanel);
        this.loadRoles();
        this.rolesPanel.setElementClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (previous != null) {
                previous.setToggled(false);
            }
            clicked.toggle();
            this.currRoleEntry = clicked;
            this.confirmButton.enable();
        });
        this.confirmButton = (OxygenKeyButton)new OxygenKeyButton(15, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.confirm", new Object[0]), 19, this::confirm).disable();
        this.addElement(this.confirmButton);
        this.cancelButton = new OxygenKeyButton(this.getWidth() - 55, this.getHeight() - 10, ClientReference.localize("oxygen_core.gui.cancel", new Object[0]), 45, this::close);
        this.addElement(this.cancelButton);
    }

    private void loadRoles() {
        ArrayList<Role> roles = new ArrayList<Role>(OxygenManagerClient.instance().getPrivilegesContainer().getServerRoles());
        Collections.sort(roles, (r1, r2) -> r2.getId() - r1.getId());
        this.rolesPanel.reset();
        for (Role role : roles) {
            this.rolesPanel.addEntry(new OxygenPanelEntry<Integer>(role.getId(), String.format("%s [%s]", role.getNameColor() + role.getName(), role.getId()), true));
        }
        this.rolesPanel.getScroller().reset();
        this.rolesPanel.getScroller().updateRowsAmount(MathUtils.clamp(roles.size(), 7, 140));
    }

    private void confirm() {
        OxygenManagerClient.instance().getPrivilegesManager().addRoleToPlayerSynced((UUID)this.section.getCurrentPlayerEntry().getWrapped(), (Integer)this.currRoleEntry.getWrapped());
        this.currRoleEntry.setToggled(false);
        this.confirmButton.disable();
        this.close();
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                this.confirm();
            }
        }
    }
}

