/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management.players;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenTexturedButton;
import austeretony.oxygen_core.client.gui.elements.OxygenWrapperPanelEntry;
import austeretony.oxygen_core.common.privilege.Role;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;

public class PlayerRolePanelEntry
extends OxygenWrapperPanelEntry<Integer> {
    private final UUID playerUUID;
    private OxygenTexturedButton removeButton;

    public PlayerRolePanelEntry(Role role, UUID playerUUID) {
        super(role.getId());
        this.playerUUID = playerUUID;
        this.setDisplayText(String.format("%s [%s]", role.getNameColor() + role.getName(), role.getId()));
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
    }

    @Override
    public void init() {
        this.removeButton = (OxygenTexturedButton)new OxygenTexturedButton(this.getWidth() - 8, 2, 6, 6, OxygenGUITextures.CROSS_ICONS, 6, 6, "").initScreen(this.getScreen());
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = !this.isEnabled() ? this.getDisabledBackgroundColor() : (this.isHovered() || this.isToggled() ? this.getHoveredBackgroundColor() : this.getEnabledBackgroundColor());
            int third = this.getWidth() / 3;
            OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, color, EnumGUIAlignment.RIGHT);
            PlayerRolePanelEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), color);
            OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, color, EnumGUIAlignment.LEFT);
            color = !this.isEnabled() ? this.getDisabledTextColor() : (this.isHovered() || this.isToggled() ? this.getHoveredTextColor() : this.getEnabledTextColor());
            float yPos = (float)(this.getHeight() - this.textHeight(this.getTextScale())) / 2.0f + 1.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)yPos, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, color, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            this.removeButton.draw(mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.removeButton.mouseClicked(mouseX, mouseY, mouseButton)) {
            OxygenManagerClient.instance().getPrivilegesManager().removeRoleFromPlayerSynced(this.playerUUID, (Integer)this.getWrapped());
            this.removeButton.disable();
            return true;
        }
        return false;
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.removeButton.mouseOver(mouseX - this.getX(), mouseY - this.getY());
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight());
    }
}

