/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.elements.OxygenContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenDefaultBackgroundWithButtonsFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenKeyButton;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenSectionSwitcher;
import austeretony.oxygen_core.client.gui.elements.OxygenSorter;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegePanelEntry;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegesManagementScreen;
import austeretony.oxygen_core.client.gui.privileges.management.privileges.callback.AddDefaultPrivilegeCallback;
import austeretony.oxygen_core.client.gui.privileges.management.privileges.callback.RemoveDefaultPrivilegeCallback;
import austeretony.oxygen_core.client.gui.privileges.management.privileges.context.RemovePrivilegeContextAction;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.ScaledResolution;

public class DefaultPrivilegesSection
extends AbstractGUISection {
    private final PrivilegesManagementScreen screen;
    private OxygenTextLabel privilegesAmountLabel;
    private OxygenKeyButton addDefaultPrivilegeButton;
    private OxygenSorter nameSorter;
    private OxygenScrollablePanel privilegesPanel;
    private AbstractGUICallback addDefaultPrivilegeCallback;
    private AbstractGUICallback removeDefaultPrivilegeCallback;
    private PrivilegePanelEntry currPrivilegeEntry;

    public DefaultPrivilegesSection(PrivilegesManagementScreen screen) {
        super(screen);
        this.screen = screen;
        this.setDisplayText(ClientReference.localize("oxygen_core.gui.privileges.management.defaultPrivileges", new Object[0]));
    }

    @Override
    public void init() {
        this.addDefaultPrivilegeCallback = new AddDefaultPrivilegeCallback(this.screen, this, 190, 153).enableDefaultBackground();
        this.removeDefaultPrivilegeCallback = new RemoveDefaultPrivilegeCallback(this.screen, this, 140, 36).enableDefaultBackground();
        this.addElement(new OxygenDefaultBackgroundWithButtonsFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.privileges.management.title", new Object[0]), EnumBaseGUISetting.TEXT_TITLE_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.privilegesAmountLabel = new OxygenTextLabel(54, this.getHeight() - 4, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f, EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt());
        this.addElement(this.privilegesAmountLabel);
        this.nameSorter = new OxygenSorter(6, 18, OxygenSorter.EnumSorting.INACTIVE, ClientReference.localize("oxygen_core.gui.name", new Object[0]));
        this.addElement(this.nameSorter);
        this.nameSorter.setSortingListener(sorting -> this.sortPrivileges(sorting == OxygenSorter.EnumSorting.DOWN ? 0 : 1));
        this.privilegesPanel = new OxygenScrollablePanel(this.screen, 6, 24, this.getWidth() - 15, 10, 1, 1120, 14, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement(this.privilegesPanel);
        this.privilegesPanel.setElementClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            this.currPrivilegeEntry = clicked;
        });
        this.privilegesPanel.initContextMenu(new OxygenContextMenu(new RemovePrivilegeContextAction()));
        this.addElement(new OxygenSectionSwitcher(this.getWidth() - 4, 4, this, this.screen.getRolesSection(), this.screen.getPlayersSection()));
        this.addDefaultPrivilegeButton = new OxygenKeyButton(0, this.getY() + this.getHeight() + this.screen.guiTop - 8, ClientReference.localize("oxygen_core.gui.privileges.management.button.addDefaultPrivilege", new Object[0]), 18, this.addDefaultPrivilegeCallback::open);
        this.addElement(this.addDefaultPrivilegeButton);
    }

    private void calculateButtonsHorizontalPosition() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        this.addDefaultPrivilegeButton.setX((sr.func_78326_a() - (10 + this.textWidth(this.addDefaultPrivilegeButton.getDisplayText(), this.addDefaultPrivilegeButton.getTextScale()))) / 2 - this.screen.guiLeft);
    }

    private void sortPrivileges(int mode) {
        ArrayList<Privilege> privileges = new ArrayList<Privilege>(OxygenManagerClient.instance().getPrivilegesContainer().getDefaultPrivileges());
        Collections.sort(privileges, (p1, p2) -> p1.getId() - p2.getId());
        this.privilegesPanel.reset();
        for (Privilege privilege : privileges) {
            this.privilegesPanel.addEntry(new PrivilegePanelEntry(privilege));
        }
        this.privilegesPanel.getScroller().reset();
        this.privilegesPanel.getScroller().updateRowsAmount(MathUtils.clamp(privileges.size(), 14, 1120));
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.addDefaultPrivilegeButton) {
            this.addDefaultPrivilegeCallback.open();
        }
    }

    public void privilegesDataReceived() {
        this.sortPrivileges(0);
        this.calculateButtonsHorizontalPosition();
    }

    public void defaultPrivilegeAdded(Privilege privilege) {
        this.sortPrivileges(0);
    }

    public void defaultPrivilegeRemoved(Privilege privilege) {
        this.sortPrivileges(0);
    }

    public PrivilegePanelEntry getCurrentPrivilegeEntry() {
        return this.currPrivilegeEntry;
    }

    public void openAddDefaultPrivilegeCallback() {
        this.addDefaultPrivilegeCallback.open();
    }

    public void openRemoveDefaultPrivilegeCallback() {
        this.removeDefaultPrivilegeCallback.open();
    }
}

