/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.information;

import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.gui.elements.OxygenDefaultBackgroundFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenDropDownList;
import austeretony.oxygen_core.client.gui.elements.OxygenPanelEntry;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.client.gui.privileges.information.PrivilegesScreen;
import austeretony.oxygen_core.client.gui.privileges.management.PrivilegePanelEntry;
import austeretony.oxygen_core.common.config.PrivilegesConfig;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.text.TextFormatting;

public class PrivilegesSection
extends AbstractGUISection {
    private OxygenTextLabel currentRoleNameLabel;
    private OxygenTextLabel roleChatFormattingLabel;
    private OxygenTextLabel currentRoleChatFormattingLabel;
    private OxygenTextLabel rolePrivilegesLabel;
    private OxygenTextLabel activeChatFormattingLabel;
    private OxygenScrollablePanel rolePrivilegesPanel;

    public PrivilegesSection(PrivilegesScreen screen) {
        super(screen);
    }

    @Override
    public void init() {
        Role role;
        this.addElement(new OxygenDefaultBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement(new OxygenTextLabel(4, 12, ClientReference.localize("oxygen_core.gui.privileges.privileges", new Object[0]), EnumBaseGUISetting.TEXT_TITLE_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.currentRoleNameLabel = new OxygenTextLabel(92, 24, "", EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt());
        this.addElement(this.currentRoleNameLabel);
        this.roleChatFormattingLabel = (OxygenTextLabel)new OxygenTextLabel(92, 33, ClientReference.localize("oxygen_core.gui.privileges.chatFormatting", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() + 0.05f, EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt()).disableFull();
        this.addElement(this.roleChatFormattingLabel);
        this.currentRoleChatFormattingLabel = new OxygenTextLabel(92, 42, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt());
        this.addElement(this.currentRoleChatFormattingLabel);
        this.rolePrivilegesLabel = (OxygenTextLabel)new OxygenTextLabel(92, 54, ClientReference.localize("oxygen_core.gui.privileges.privileges", new Object[0]), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() + 0.05f, EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt()).disableFull();
        this.addElement(this.rolePrivilegesLabel);
        this.rolePrivilegesPanel = new OxygenScrollablePanel(this.screen, 92, 56, 200, 10, 1, 200, 5, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement(this.rolePrivilegesPanel);
        this.rolePrivilegesPanel.disableFull();
        this.addElement(new OxygenTextLabel(6, 24, ClientReference.localize("oxygen_core.gui.privileges.information.playerRoles", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        Set<Integer> ids = PrivilegesProviderClient.getPlayerRolesIds();
        OxygenScrollablePanel rolesPanel = new OxygenScrollablePanel(this.screen, 6, 26, 80, 10, 1, 5, 5, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement(rolesPanel);
        for (int roleId : ids) {
            role = PrivilegesProviderClient.getPlayerRole(roleId);
            rolesPanel.addEntry(new OxygenPanelEntry<Role>(role, role.getNameColor() + role.getName(), true));
        }
        rolesPanel.getScroller().updateRowsAmount(MathUtils.clamp(ids.size(), 5, 5));
        rolesPanel.setElementClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (previous != null) {
                previous.setToggled(false);
            }
            clicked.toggle();
            this.displayRoleInformation((Role)clicked.getWrapped());
        });
        if (!ids.isEmpty()) {
            this.displayRoleInformation(PrivilegesProviderClient.getPlayerRole((Integer)((TreeSet)ids).first()));
        }
        this.addElement(new OxygenTextLabel(6, 144, ClientReference.localize("oxygen_core.gui.privileges.defaultPrivileges", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        OxygenScrollablePanel defaultPrivilegesPanel = new OxygenScrollablePanel(this.screen, 6, 146, 200, 10, 1, 200, 5, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement(defaultPrivilegesPanel);
        Collection<Privilege> privileges = OxygenManagerClient.instance().getPrivilegesContainer().getDefaultPrivileges();
        for (Privilege privilege : privileges) {
            defaultPrivilegesPanel.addEntry(new PrivilegePanelEntry(privilege));
        }
        defaultPrivilegesPanel.getScroller().updateRowsAmount(MathUtils.clamp(privileges.size(), 5, 200));
        this.addElement(new OxygenTextLabel(6, 122, ClientReference.localize("oxygen_core.gui.privileges.chatFormatting", new Object[0]), EnumBaseGUISetting.TEXT_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        this.activeChatFormattingLabel = new OxygenTextLabel(90, 131, "", EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt());
        this.addElement(this.activeChatFormattingLabel);
        this.updateChatFormatting(OxygenManagerClient.instance().getPrivilegesContainer().getChatFormattingRoleId());
        Role chatFormattingRole = OxygenManagerClient.instance().getPrivilegesContainer().getChatFormattingRole();
        String defaultFormattingStr = ClientReference.localize("oxygen_core.gui.privileges.defaultFormatting", new Object[0]);
        String chatFormattingRoleNameStr = chatFormattingRole == null ? defaultFormattingStr : chatFormattingRole.getName();
        OxygenDropDownList rolesList = (OxygenDropDownList)new OxygenDropDownList(6, 124, 80, (chatFormattingRole == null ? TextFormatting.GRAY : chatFormattingRole.getNameColor()) + chatFormattingRoleNameStr).setEnabled(PrivilegesConfig.ENABLE_CHAT_FORMATTING_ROLE_MANAGEMENT.asBoolean());
        this.addElement(rolesList);
        for (int roleId : ids) {
            role = PrivilegesProviderClient.getPlayerRole(roleId);
            rolesList.addElement(new OxygenDropDownList.OxygenDropDownListWrapperEntry<Integer>(role.getId(), role.getNameColor() + role.getName()));
        }
        rolesList.addElement(new OxygenDropDownList.OxygenDropDownListWrapperEntry<Integer>(-1, defaultFormattingStr));
        rolesList.setElementClickListener(element -> {
            OxygenManagerClient.instance().getPrivilegesManager().setChatFormattingRoleSynced((Integer)element.getWrapped());
            this.updateChatFormatting((Integer)element.getWrapped());
        });
    }

    private void displayRoleInformation(Role role) {
        this.roleChatFormattingLabel.enableFull();
        this.rolePrivilegesLabel.enableFull();
        this.rolePrivilegesPanel.enableFull();
        this.currentRoleNameLabel.setDisplayText(role.getNameColor() + role.getName());
        ArrayList<Privilege> privileges = new ArrayList<Privilege>(role.getPrivileges());
        Collections.sort(privileges, (p1, p2) -> p1.getId() - p2.getId());
        this.rolePrivilegesPanel.reset();
        for (Privilege privilege : privileges) {
            this.rolePrivilegesPanel.addEntry(new PrivilegePanelEntry(privilege));
        }
        this.rolePrivilegesPanel.getScroller().reset();
        this.rolePrivilegesPanel.getScroller().updateRowsAmount(MathUtils.clamp(role.getPrivileges().size(), 5, 200));
        if (PrivilegesConfig.ENABLE_FORMATTED_CHAT.asBoolean()) {
            if (PrivilegesConfig.ENABLE_CUSTOM_FORMATTED_CHAT.asBoolean()) {
                String result;
                String prefix = null;
                TextFormatting defaultColor = TextFormatting.values()[PrivilegesConfig.DEFAULT_CHAT_COLOR.asInt()];
                if (!role.getPrefix().isEmpty()) {
                    prefix = role.getPrefixColor() + role.getPrefix() + TextFormatting.RESET;
                }
                String username = role.getUsernameColor() + ClientReference.getClientPlayer().func_70005_c_() + TextFormatting.RESET;
                String string = result = !role.getPrefix().isEmpty() ? PrivilegesConfig.FORMATTED_CHAT_PREFIX_PATTERN.asString() : PrivilegesConfig.FORMATTED_CHAT_PATTERN.asString();
                if (prefix != null) {
                    result = defaultColor + result.replace("@prefix", prefix + defaultColor);
                }
                result = result.replace("@username", username + defaultColor);
                result = result + role.getChatColor() + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0]);
                this.currentRoleChatFormattingLabel.setDisplayText(result);
            } else {
                StringBuilder formattedUsername = new StringBuilder();
                if (!role.getPrefix().isEmpty()) {
                    formattedUsername.append(role.getPrefixColor());
                    formattedUsername.append("[");
                    formattedUsername.append(role.getPrefix());
                    formattedUsername.append("]");
                    formattedUsername.append(TextFormatting.RESET);
                }
                formattedUsername.append(role.getUsernameColor());
                formattedUsername.append(ClientReference.getClientPlayer().func_70005_c_());
                formattedUsername.append(TextFormatting.RESET);
                this.currentRoleChatFormattingLabel.setDisplayText(ClientReference.localize("chat.type.text", formattedUsername.toString(), role.getChatColor() + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0])));
            }
        } else {
            this.currentRoleChatFormattingLabel.setDisplayText(ClientReference.localize("chat.type.text", ClientReference.getClientPlayer().func_70005_c_(), ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0])));
        }
    }

    private void updateChatFormatting(int roleId) {
        if (PrivilegesConfig.ENABLE_FORMATTED_CHAT.asBoolean()) {
            Role role = PrivilegesProviderClient.getPlayerRole(roleId);
            if (role != null) {
                if (PrivilegesConfig.ENABLE_CUSTOM_FORMATTED_CHAT.asBoolean()) {
                    String result;
                    String prefix = null;
                    TextFormatting defColor = TextFormatting.values()[PrivilegesConfig.DEFAULT_CHAT_COLOR.asInt()];
                    if (!role.getPrefix().isEmpty()) {
                        prefix = role.getPrefixColor() + role.getPrefix() + TextFormatting.RESET;
                    }
                    String username = role.getUsernameColor() + ClientReference.getClientPlayer().func_70005_c_() + TextFormatting.RESET;
                    String string = result = !role.getPrefix().isEmpty() ? PrivilegesConfig.FORMATTED_CHAT_PREFIX_PATTERN.asString() : PrivilegesConfig.FORMATTED_CHAT_PATTERN.asString();
                    if (prefix != null) {
                        result = defColor + result.replace("@prefix", prefix + defColor);
                    }
                    result = result.replace("@username", username + defColor);
                    result = result + role.getChatColor() + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0]);
                    this.activeChatFormattingLabel.setDisplayText(result);
                } else {
                    StringBuilder formattedUsername = new StringBuilder();
                    if (!role.getPrefix().isEmpty()) {
                        formattedUsername.append(role.getPrefixColor());
                        formattedUsername.append("[");
                        formattedUsername.append(role.getPrefix());
                        formattedUsername.append("]");
                        formattedUsername.append(TextFormatting.RESET);
                    }
                    formattedUsername.append(role.getUsernameColor());
                    formattedUsername.append(ClientReference.getClientPlayer().func_70005_c_());
                    formattedUsername.append(TextFormatting.RESET);
                    this.activeChatFormattingLabel.setDisplayText(ClientReference.localize("chat.type.text", formattedUsername.toString(), role.getChatColor() + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0])));
                }
            } else if (PrivilegesConfig.ENABLE_CUSTOM_FORMATTED_CHAT.asBoolean()) {
                this.activeChatFormattingLabel.setDisplayText(TextFormatting.values()[PrivilegesConfig.DEFAULT_CHAT_COLOR.asInt()] + PrivilegesConfig.FORMATTED_CHAT_PATTERN.asString().replace("@username", ClientReference.getClientPlayer().func_70005_c_()) + ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0]));
            } else {
                this.activeChatFormattingLabel.setDisplayText(ClientReference.localize("chat.type.text", ClientReference.getClientPlayer().func_70005_c_(), ClientReference.localize("oxygen_core.gui.privileges.testMessage", new Object[0])));
            }
        } else {
            this.activeChatFormattingLabel.setDisplayText(ClientReference.localize("oxygen_core.gui.privileges.chatFormattingDisabled", new Object[0]));
        }
    }

    @Override
    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }
}

