/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.overlay;

import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.overlay.Overlay;
import austeretony.oxygen_core.client.settings.gui.EnumCoreGUISetting;
import austeretony.oxygen_core.common.config.OxygenConfig;
import austeretony.oxygen_core.common.notification.Notification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class RequestOverlay
implements Overlay {
    Notification notification;
    Minecraft mc;
    String acceptKeyName;
    String rejectKeyName;
    String acceptStr;
    String rejectStr;
    String requestStr;
    int x;
    int y;
    int baseOverlayTextColor;
    int additionalOverlayTextColor;
    int baseBackgroundColor;
    int additionalBackgroundColor;
    int acceptKeyNameWidth;
    int rejectKeyNameWidth;
    boolean acceptKeyEnabled;
    boolean rejectKeyEnabled;
    float scale;

    @Override
    public boolean valid() {
        if (OxygenManagerClient.instance().getNotificationsManager() != null && OxygenManagerClient.instance().getNotificationsManager().pendingRequestExist()) {
            Notification notification = OxygenManagerClient.instance().getNotificationsManager().getLatestRequest();
            if (this.notification == null || this.notification.getId() != notification.getId()) {
                this.notification = notification;
                this.initOverlay();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean drawWhileInGUI() {
        return false;
    }

    private void initOverlay() {
        this.mc = ClientReference.getMinecraft();
        this.scale = EnumBaseGUISetting.OVERLAY_SCALE.get().asFloat();
        this.requestStr = ClientReference.localize(this.notification.getDescription(), this.notification.getArguments());
        int requestWidth = (int)((float)this.mc.field_71466_p.func_78256_a(this.requestStr) * this.scale);
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        this.x = (scaledResolution.func_78326_a() - requestWidth) / 2;
        this.y = scaledResolution.func_78328_b() / 2 + EnumCoreGUISetting.REQUEST_OVERLAY_OFFSET.get().asInt();
        this.baseOverlayTextColor = EnumBaseGUISetting.OVERLAY_TEXT_BASE_COLOR.get().asInt();
        this.additionalOverlayTextColor = EnumBaseGUISetting.OVERLAY_TEXT_ADDITIONAL_COLOR.get().asInt();
        this.baseBackgroundColor = EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt();
        this.additionalBackgroundColor = EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt();
        this.acceptKeyEnabled = OxygenConfig.ENABLE_ACCEPT_KEY.asBoolean();
        this.acceptKeyName = this.acceptKeyEnabled ? String.format("[%s]", OxygenHelperClient.getKeyHandler().getAcceptKeybinding().getDisplayName()) : "/oxygenc core -request -accept";
        this.rejectKeyEnabled = OxygenConfig.ENABLE_REJECT_KEY.asBoolean();
        this.rejectKeyName = this.rejectKeyEnabled ? String.format("[%s]", OxygenHelperClient.getKeyHandler().getRejectKeybinding().getDisplayName()) : "/oxygenc core -request -reject";
        this.acceptStr = ClientReference.localize("oxygen_core.request.accept", new Object[0]);
        this.rejectStr = ClientReference.localize("oxygen_core.request.reject", new Object[0]);
        this.acceptKeyNameWidth = this.mc.field_71466_p.func_78256_a(this.acceptKeyName);
        this.rejectKeyNameWidth = this.mc.field_71466_p.func_78256_a(this.rejectKeyName);
    }

    @Override
    public void draw(float partialTicks) {
        if (this.notification == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
        this.mc.field_71466_p.func_175065_a(this.requestStr, 0.0f, 0.0f, this.additionalOverlayTextColor, true);
        if (this.acceptKeyEnabled) {
            this.mc.field_71466_p.func_175065_a(this.acceptStr, (float)(6 + this.acceptKeyNameWidth), 15.0f, this.baseOverlayTextColor, true);
        }
        this.mc.field_71466_p.func_175065_a(this.acceptKeyName, 2.0f, 15.0f, this.additionalOverlayTextColor, true);
        if (this.rejectKeyEnabled) {
            this.mc.field_71466_p.func_175065_a(this.rejectStr, (float)(6 + this.rejectKeyNameWidth), 29.0f, this.baseOverlayTextColor, true);
        }
        this.mc.field_71466_p.func_175065_a(this.rejectKeyName, 2.0f, 29.0f, this.additionalOverlayTextColor, true);
        this.mc.field_71466_p.func_175065_a("(" + String.valueOf((this.notification.getExpirationTimeStamp() - System.currentTimeMillis()) / 1000L) + ")", 0.0f, 43.0f, this.additionalOverlayTextColor, true);
        GlStateManager.func_179121_F();
    }
}

