/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.currency.CurrencyProperties;
import austeretony.oxygen_core.client.gui.ItemRenderHelper;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.util.OxygenUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class OxygenCurrencyValue
extends GUISimpleElement<OxygenCurrencyValue> {
    private ItemStack stack;
    private CurrencyProperties properties;
    private long value;
    private boolean isRed;

    public OxygenCurrencyValue(int x, int y) {
        this.setPosition(x, y);
        this.setSize(8, 8);
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f);
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.INACTIVE_TEXT_COLOR.get().asInt(), 0);
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt());
        this.enableFull();
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.stack == null) {
                if (this.properties != null) {
                    GlStateManager.func_179147_l();
                    this.mc.func_110434_K().func_110577_a(this.properties.getIcon());
                    GUIAdvancedElement.drawCustomSizedTexturedRect(this.properties.getXOffset(), (this.getHeight() - this.properties.getIconHeight()) / 2 + this.properties.getYOffset(), 0, 0, this.properties.getIconWidth(), this.properties.getIconHeight(), this.properties.getIconWidth(), this.properties.getIconHeight());
                    GlStateManager.func_179084_k();
                }
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                RenderHelper.func_74520_c();
                GlStateManager.func_179126_j();
                ItemRenderHelper.renderItemWithoutEffectIntoGUI(this.stack, 0, 0);
                GlStateManager.func_179097_i();
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-2.0f - (float)this.textWidth(this.getDisplayText(), this.getTextScale())), (float)(((float)this.getHeight() - (float)this.textHeight(this.getTextScale())) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, this.isRed ? this.getDisabledTextColor() : this.getEnabledTextColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + 8 && mouseY < this.getY() + 8) {
            if (this.stack != null) {
                this.screen.drawToolTip(this.stack, mouseX - this.textWidth(this.stack.func_82833_r(), 1.0f) - (ClientReference.getGameSettings().field_82882_x ? 75 : 25), mouseY);
            } else if (this.properties != null) {
                float width = (float)this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor()) + 6.0f;
                float height = 9.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.getX() + (float)this.getWidth() / 2.0f - width / 2.0f), (float)((float)this.getY() - height - 2.0f), (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                OxygenCurrencyValue.drawRect(0, 0, (int)width, (int)height, this.getTooltipBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, 0.0, 0.3, height, this.getStaticBackgroundColor());
                OxygenGUIUtils.drawRect((double)width - 0.4, 0.0, width, height, this.getStaticBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, 0.0, width, 0.4, this.getStaticBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, (double)height - 0.4, width, height, this.getStaticBackgroundColor());
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((width - (float)this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor())) / 2.0f), (float)((height - (float)this.textHeight(this.getTooltipScaleFactor())) / 2.0f + 1.0f), (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.getTooltipText(), 0.0f, 0.0f, this.getTooltipTextColor(), false);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
            }
        }
    }

    public void setValue(ItemStack stack, int amount) {
        this.properties = null;
        this.stack = stack;
        this.value = amount;
        this.setDisplayText(OxygenUtils.formatCurrencyValue(String.valueOf(amount)));
    }

    public void setValue(int currencyIndex, long value) {
        this.stack = null;
        this.properties = OxygenHelperClient.getCurrencyProperties(currencyIndex);
        if (this.properties != null) {
            this.initTooltip(this.properties.getLocalizedName(), EnumBaseGUISetting.TOOLTIP_TEXT_COLOR.get().asInt(), EnumBaseGUISetting.TOOLTIP_BACKGROUND_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        }
        this.value = value;
        this.setDisplayText(OxygenUtils.formatCurrencyValue(String.valueOf(value)));
    }

    public void updateValue(long value) {
        this.value = value;
        this.setDisplayText(OxygenUtils.formatCurrencyValue(String.valueOf(value)));
    }

    public long getValue() {
        return this.value;
    }

    public void setRed(boolean flag) {
        this.isRed = flag;
    }
}

