/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.alternateui.util.GUISoundEffect;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenContextMenu
extends GUIContextMenu {
    private final OxygenContextMenuEntry[] elements;
    private GUISoundEffect openSound = new GUISoundEffect(OxygenSoundEffects.CONTEXT_OPEN.getSoundEvent(), 0.5f, 1.0f);
    private GUISoundEffect closeSound = new GUISoundEffect(OxygenSoundEffects.CONTEXT_CLOSE.getSoundEvent(), 0.5f, 1.0f);
    private GUIBaseElement currentElement;

    public OxygenContextMenu(OxygenContextMenuAction ... actions) {
        super(0, 0);
        this.elements = new OxygenContextMenuEntry[actions.length];
        int index = 0;
        for (OxygenContextMenuAction action : actions) {
            int n = index++;
            OxygenContextMenuEntry oxygenContextMenuEntry = new OxygenContextMenuEntry(60, 9, action);
            this.elements[n] = oxygenContextMenuEntry;
            this.bind(oxygenContextMenuEntry);
        }
        this.setSize(60, 9 * actions.length);
        this.setDynamicBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt(), EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt(), 0);
    }

    @Override
    public void drawContextMenu(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            for (OxygenContextMenuEntry element : this.elements) {
                element.mouseOver(mouseX, mouseY);
            }
            this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && (float)mouseX < (float)this.getX() + (float)this.getWidth() * this.getScale() && mouseY < this.getY() + this.getHeight());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OxygenContextMenu.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, this.getHeight(), this.getDisabledBackgroundColor());
            OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, 0.0, this.getWidth(), this.getHeight(), this.getDisabledBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, -0.4, this.getWidth(), 0.0, this.getDisabledBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, this.getHeight(), this.getWidth(), (float)this.getHeight() + 0.4f, this.getDisabledBackgroundColor());
            GlStateManager.func_179121_F();
            for (OxygenContextMenuEntry element : this.elements) {
                element.draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = this.isHovered();
        if (flag && mouseButton == 0) {
            for (OxygenContextMenuEntry element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                element.action.execute(this.currentElement);
                element.setHovered(false);
                this.close();
                return true;
            }
        } else {
            this.close();
        }
        return false;
    }

    @Override
    public void open(GUIBaseElement element, int mouseX, int mouseY) {
        if (this.elements.length != 0) {
            this.setPosition(mouseX, mouseY);
            int index = 0;
            for (OxygenContextMenuEntry action : this.elements) {
                this.currentElement = element;
                action.setDisplayText(action.action.getLocalizedName(element));
                action.setPosition(this.getX(), this.getY() + index * action.getHeight());
                if (action.action.isValid(element)) {
                    action.setEnabled(true);
                }
                action.setVisible(true);
                ++index;
            }
            this.setDragged(true);
            this.enableFull();
            if (this.openSound != null) {
                this.mc.field_71439_g.func_184185_a(this.openSound.sound, this.openSound.volume, this.openSound.pitch);
            }
        }
    }

    @Override
    public void close() {
        this.setDragged(false);
        this.disableFull();
        for (OxygenContextMenuEntry action : this.elements) {
            action.disableFull();
        }
        if (this.closeSound != null) {
            this.mc.field_71439_g.func_184185_a(this.closeSound.sound, this.closeSound.volume, this.closeSound.pitch);
        }
    }

    public static interface OxygenContextMenuAction {
        public String getLocalizedName(GUIBaseElement var1);

        public boolean isValid(GUIBaseElement var1);

        public void execute(GUIBaseElement var1);
    }

    public static class OxygenContextMenuEntry
    extends GUISimpleElement<OxygenContextMenuEntry> {
        public final OxygenContextMenuAction action;

        public OxygenContextMenuEntry(int width, int height, OxygenContextMenuAction action) {
            this.action = action;
            this.setSize(width, height);
            this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f);
            this.setStaticBackgroundColor(EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
            this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isHovered()) {
                int third = this.getWidth() / 3;
                OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.RIGHT);
                OxygenContextMenuEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), this.getStaticBackgroundColor());
                OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.LEFT);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }
}

