/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;

public class OxygenButton
extends GUISimpleElement<OxygenButton> {
    @Nullable
    private ClickListener clickListener;
    @Nullable
    private KeyPressListener keyPressListener;
    private int keyCode;

    public OxygenButton(int xPosition, int yPosition, int buttonWidth, int buttonHeight, String displayText) {
        this.setPosition(xPosition, yPosition);
        this.setSize(buttonWidth, buttonHeight);
        this.setTextScale(EnumBaseGUISetting.TEXT_BUTTON_SCALE.get().asFloat());
        this.setDisplayText(displayText);
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.BUTTON_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.BUTTON_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.BUTTON_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.getSoundEvent());
        this.enableFull();
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void setKeyPressListener(int keyCode, KeyPressListener keyPressListener) {
        this.keyCode = keyCode;
        this.keyPressListener = keyPressListener;
        String displayText = this.getDisplayText();
        Object[] objectArray = new Object[2];
        ClientReference.getGameSettings();
        objectArray[0] = GameSettings.func_74298_c((int)keyCode);
        objectArray[1] = displayText;
        displayText = String.format("[%s] %s", objectArray);
        this.setDisplayText(displayText);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag) {
            if (this.clickListener != null) {
                this.clickListener.mouseClick(mouseX, mouseY, mouseButton);
            }
            this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
            this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            }
        }
        return flag;
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        if (this.isEnabled() && this.keyPressListener != null && keyCode == this.keyCode) {
            this.keyPressListener.keyPressed();
        }
        return false;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
            }
            OxygenButton.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, this.getHeight(), color);
            OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, 0.0, this.getWidth(), this.getHeight(), color);
            OxygenGUIUtils.drawRect(0.0, 0.0, this.getWidth(), 0.4, color);
            OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() - 0.4, this.getWidth(), this.getHeight(), color);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((this.getWidth() - this.textWidth(this.getDisplayText(), this.getTextScale())) / 2), (float)((this.getHeight() - this.textHeight(this.getTextScale())) / 2 + 1), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            color = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledTextColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, color, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @FunctionalInterface
    public static interface KeyPressListener {
        public void keyPressed();
    }

    @FunctionalInterface
    public static interface ClickListener {
        public void mouseClick(int var1, int var2, int var3);
    }
}

