/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.EnumActivityStatus;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenActivityStatusSwitcher
extends GUISimpleElement<OxygenActivityStatusSwitcher> {
    private final ActivityStatusSwitcherEntry[] elements;
    @Nullable
    private ActivityStatusChangeListener statusChangeListener;
    private final int width;
    private final int height;
    private int previous = -1;
    private int current = -1;

    public OxygenActivityStatusSwitcher(int xPosition, int yPosition) {
        this.setPosition(xPosition, yPosition);
        this.setSize(14, 8);
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat());
        this.setDisplayText(OxygenHelperClient.getPlayerUsername());
        this.elements = new ActivityStatusSwitcherEntry[EnumActivityStatus.values().length];
        int width = 0;
        int height = this.textHeight(this.getTextScale()) + 3;
        for (EnumActivityStatus status : EnumActivityStatus.values()) {
            int textWidth = this.textWidth(status.localized(), this.getTextScale());
            if (width != 0 && width >= textWidth) continue;
            width = textWidth + 6;
        }
        this.width = width;
        this.height = height * EnumActivityStatus.values().length;
        int index = 0;
        for (EnumActivityStatus status : EnumActivityStatus.values()) {
            ActivityStatusSwitcherEntry element = new ActivityStatusSwitcherEntry(status);
            element.initScreen(this.getScreen());
            element.setPosition(this.getX(), this.getY() + height * (index + 1) + 1);
            element.setSize(width, height);
            element.setTextScale(this.getTextScale() - 0.05f);
            this.elements[index++] = element;
            this.bind(element);
        }
        this.setDynamicBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt(), EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt(), 0);
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.enableFull();
    }

    public void updateActivityStatus() {
        this.current = OxygenHelperClient.getPlayerActivityStatus().ordinal();
    }

    public void setActivityStatusChangeListener(ActivityStatusChangeListener listener) {
        this.statusChangeListener = listener;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged()) {
                int size = this.elements.length;
                OxygenActivityStatusSwitcher.drawRect(-2, this.getHeight(), this.width + 2, this.getHeight() + this.height + 2, this.getEnabledBackgroundColor());
                OxygenGUIUtils.drawRect(-2.4, this.getHeight(), -2.0, this.getHeight() + this.height + 2, this.getDisabledBackgroundColor());
                OxygenGUIUtils.drawRect((double)this.width + 1.6, this.getHeight(), (double)this.width + 2.0, this.getHeight() + this.height + 2, this.getDisabledBackgroundColor());
                OxygenGUIUtils.drawRect(-2.0, this.getHeight(), (double)this.width + 2.0, (double)this.getHeight() + 0.4, this.getDisabledBackgroundColor());
                OxygenGUIUtils.drawRect(-2.0, this.getHeight() + this.height + 2, (double)this.width + 2.0, (double)(this.getHeight() + this.height + 2) + 0.4, this.getDisabledBackgroundColor());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)4.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 14.0f, 0.0f, this.getEnabledTextColor(), false);
            GlStateManager.func_179121_F();
            if (this.current != -1) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STATUS_ICONS);
                GUIAdvancedElement.drawCustomSizedTexturedRect(0, 1, this.current * 3, 0, 3, 3, 12, 3);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconU = 0;
            if (!this.isEnabled()) {
                iconU = 3;
            } else if (this.isHovered() && !this.isDragged()) {
                iconU = 6;
            }
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.SORT_DOWN_ICONS);
            GUIAdvancedElement.drawCustomSizedTexturedRect(6, 1, iconU, 0, 3, 3, 9, 3);
            GlStateManager.func_179121_F();
            if (this.isDragged()) {
                for (ActivityStatusSwitcherEntry element : this.elements) {
                    element.draw(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            this.setHovered(mouseX >= this.getX() && mouseY >= this.getY() && mouseX <= this.getX() + (int)(this.getScale() * (float)this.getWidth()) && mouseY < this.getY() + (int)(this.getScale() * (float)(this.isDragged() ? this.getHeight() * (this.elements.length + 1) : this.getHeight())));
            if (this.isDragged()) {
                for (ActivityStatusSwitcherEntry element : this.elements) {
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            for (ActivityStatusSwitcherEntry element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setDragged(false);
                element.setHovered(false);
                if (this.previous == -1 || this.previous != element.activityStatus.ordinal()) {
                    OxygenManagerClient.instance().getClientDataManager().changeActivityStatusSynced(element.activityStatus);
                    OxygenHelperClient.getPlayerSharedData().setByte(0, element.activityStatus.ordinal());
                }
                if (this.statusChangeListener != null) {
                    this.statusChangeListener.activityStatusChanged(element.activityStatus);
                }
                this.current = this.previous = element.activityStatus.ordinal();
                this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.CONTEXT_CLOSE.getSoundEvent(), 0.5f, 1.0f);
                return true;
            }
        }
        if (flag && mouseButton == 0 && !this.isDragged()) {
            this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.DROP_DOWN_LIST_OPEN.getSoundEvent(), 0.5f, 1.0f);
        }
        this.setDragged(flag && mouseButton == 0);
        return false;
    }

    public static class ActivityStatusSwitcherEntry
    extends GUISimpleElement<ActivityStatusSwitcherEntry> {
        public final EnumActivityStatus activityStatus;

        public ActivityStatusSwitcherEntry(EnumActivityStatus activityStatus) {
            this.activityStatus = activityStatus;
            this.setDisplayText(this.activityStatus.localized());
            this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
            this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
            this.enableFull();
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isHovered()) {
                int third = this.getWidth() / 3;
                OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.RIGHT);
                ActivityStatusSwitcherEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), this.getStaticBackgroundColor());
                OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.LEFT);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STATUS_ICONS);
            GUIAdvancedElement.drawCustomSizedTexturedRect(0, 3, this.activityStatus.ordinal() * 3, 0, 3, 3, 12, 3);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)4.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 4.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @FunctionalInterface
    public static interface ActivityStatusChangeListener {
        public void activityStatusChanged(EnumActivityStatus var1);
    }
}

