/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.currency;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.client.currency.CurrencyProperties;
import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.common.watcher.WatchedValue;
import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class CurrencyManagerClient {
    private CurrencyProperties commonProperties;
    private final Map<Integer, CurrencyProperties> properties = new HashMap<Integer, CurrencyProperties>(3);

    public void registerCurrencyProperties(CurrencyProperties properties) {
        if (properties.getIndex() == 0) {
            this.commonProperties = properties;
        }
        this.properties.put(properties.getIndex(), properties);
        WatcherHelperClient.registerValue(new WatchedValue(properties.getIndex(), 8));
    }

    public Collection<CurrencyProperties> getProperties() {
        return this.properties.values();
    }

    public CurrencyProperties getCommonCurrencyProperties() {
        return this.commonProperties;
    }

    public CurrencyProperties getProperties(int index) {
        if (index == 0) {
            return this.commonProperties;
        }
        return this.properties.get(index);
    }

    public void loadProperties() {
        for (CurrencyProperties properties : this.properties.values()) {
            this.loadData(properties);
            this.loadIcon(properties);
        }
    }

    private void loadData(CurrencyProperties properties) {
        String pathStr = OxygenHelperCommon.getConfigFolder() + "data/client/properties/currency/currency_" + properties.getIndex() + ".json";
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                properties.deserialize(JsonUtils.getExternalJsonData(pathStr).getAsJsonObject());
                OxygenMain.LOGGER.info("[Core] Loaded currency properties with index: <{}>.", (Object)properties.getIndex());
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to load currency properties with index: <{}>.", (Object)properties.getIndex());
                exception.printStackTrace();
            }
        } else {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                JsonUtils.createExternalJsonFile(pathStr, (JsonElement)properties.serialize());
                OxygenMain.LOGGER.info("[Core] Created currency properties file with index: <{}>.", (Object)properties.getIndex());
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to create currency properties file with index: <{}>.", (Object)properties.getIndex());
                exception.printStackTrace();
            }
        }
    }

    private void loadIcon(CurrencyProperties properties) {
        String pathStr = OxygenHelperCommon.getConfigFolder() + "data/client/properties/currency/currency_" + properties.getIndex() + ".png";
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                properties.setIcon(ClientReference.getMinecraft().func_110434_K().func_110578_a("currency_" + properties.getIndex(), new DynamicTexture(ImageIO.read(new File(pathStr)))));
                OxygenMain.LOGGER.info("[Core] Loaded currency icon with index: <{}>.", (Object)properties.getIndex());
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to load currency icon with index: <{}>.", (Object)properties.getIndex());
                exception.printStackTrace();
            }
        } else {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedImage icon = null;
                try {
                    icon = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("assets/" + properties.getIcon().func_110624_b() + "/" + properties.getIcon().func_110623_a()));
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                if (icon != null) {
                    ImageIO.write(icon, "png", path.toFile());
                    OxygenMain.LOGGER.info("[Core] Created currency icon with index: <{}>.", (Object)properties.getIndex());
                } else {
                    OxygenMain.LOGGER.error("[Core] Failed to load currency icon with index: <{}>. External icon creation failed.", (Object)properties.getIndex());
                }
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] Failed to create currency icon with index: <{}>.", (Object)properties.getIndex());
                exception.printStackTrace();
            }
        }
    }
}

