/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.command;

import austeretony.oxygen_core.client.OxygenGUIManager;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.privilege.PrivilegeRegistry;
import austeretony.oxygen_core.common.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CoreArgumentClient
implements ArgumentExecutor {
    @Override
    public String getName() {
        return "core";
    }

    @Override
    public void process(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 2) {
            if (args[1].equals("-privileges")) {
                int privilegeId;
                PrivilegeRegistry.PrivilegeRegistryEntry entry;
                if (args.length == 2) {
                    OxygenHelperClient.scheduleTask(() -> ClientReference.delegateToClientThread(OxygenGUIManager::openPrivilegesMenu), 100L, TimeUnit.MILLISECONDS);
                } else if (args.length == 3) {
                    if (args[2].equals("-management")) {
                        OxygenHelperClient.scheduleTask(() -> ClientReference.delegateToClientThread(OxygenGUIManager::openPrivilegesManagementMenu), 100L, TimeUnit.MILLISECONDS);
                    }
                } else if (args.length == 4 && args[2].equals("-get-value") && (entry = PrivilegeRegistry.getRegistryEntry(privilegeId = CommandBase.func_175764_a((String)args[3], (int)0, (int)Short.MAX_VALUE))) != null) {
                    switch (entry.type) {
                        case BOOLEAN: {
                            ClientReference.showChatMessage("oxygen_core.command.oxygenc.privileges.getValue", entry.name, entry.id, PrivilegesProviderClient.getAsBoolean(privilegeId, false));
                            break;
                        }
                        case INT: {
                            ClientReference.showChatMessage("oxygen_core.command.oxygenc.privileges.getValue", entry.name, entry.id, PrivilegesProviderClient.getAsInt(privilegeId, -1));
                            break;
                        }
                        case LONG: {
                            ClientReference.showChatMessage("oxygen_core.command.oxygenc.privileges.getValue", entry.name, entry.id, PrivilegesProviderClient.getAsLong(privilegeId, -1L));
                            break;
                        }
                        case FLOAT: {
                            ClientReference.showChatMessage("oxygen_core.command.oxygenc.privileges.getValue", entry.name, entry.id, Float.valueOf(PrivilegesProviderClient.getAsFloat(privilegeId, -1.0f)));
                            break;
                        }
                        case STRING: {
                            ClientReference.showChatMessage("oxygen_core.command.oxygenc.privileges.getValue", entry.name, entry.id, PrivilegesProviderClient.getAsString(privilegeId, "NONE"));
                            break;
                        }
                    }
                }
            } else if (args[1].equals("-currency")) {
                if (args.length == 4 && args[2].equals("-balance")) {
                    int currencyIndex = CommandBase.func_175764_a((String)args[3], (int)0, (int)127);
                    if (OxygenManagerClient.instance().getCurrencyManager().getProperties(currencyIndex) == null) {
                        throw new WrongUsageException("Invalid currency index: %s", new Object[]{currencyIndex});
                    }
                    ClientReference.showChatMessage("oxygen_core.command.oxygenc.currency.balance", currencyIndex, WatcherHelperClient.getLong(currencyIndex));
                }
            } else if (args[1].equals("-notifications")) {
                OxygenHelperClient.scheduleTask(() -> ClientReference.delegateToClientThread(OxygenGUIManager::openNotificationsMenu), 100L, TimeUnit.MILLISECONDS);
            } else if (args[1].equals("-settings")) {
                if (args.length == 2) {
                    OxygenHelperClient.scheduleTask(() -> ClientReference.delegateToClientThread(OxygenGUIManager::openSettingsMenu), 100L, TimeUnit.MILLISECONDS);
                } else if (args[2].equals("-reload-settings")) {
                    OxygenManagerClient.instance().getClientSettingManager().loadSettings();
                    ClientReference.showChatMessage("oxygen_core.command.oxygenc.reloadSettings", new Object[0]);
                } else if (args[2].equals("-reload-properties")) {
                    OxygenManagerClient.instance().getCurrencyManager().loadProperties();
                    ClientReference.showChatMessage("oxygen_core.command.oxygenc.reloadProperties", new Object[0]);
                }
            } else if (args[1].equals("-request")) {
                if (args.length == 3) {
                    if (args[2].equals("-accept")) {
                        OxygenManagerClient.instance().getNotificationsManager().acceptRequestSynced();
                    } else if (args[2].equals("-reject")) {
                        OxygenManagerClient.instance().getNotificationsManager().rejectRequestSynced();
                    }
                }
            } else if (args[1].equals("-entity")) {
                if (args.length == 3) {
                    if (args[2].equals("-get-id")) {
                        if (ClientReference.getPointedEntity() != null) {
                            int entityId = ClientReference.getEntityId(ClientReference.getPointedEntity());
                            ClientReference.getMinecraft().field_71456_v.func_146158_b().func_146239_a(String.valueOf(entityId));
                            ClientReference.showChatMessage(String.format("Entity id: %d", entityId), new Object[0]);
                        }
                    } else if (args[2].equals("-get-uuid") && ClientReference.getPointedEntity() != null) {
                        UUID entityUUID = ClientReference.getPersistentUUID(ClientReference.getPointedEntity());
                        ClientReference.getMinecraft().field_71456_v.func_146158_b().func_146239_a(String.valueOf(entityUUID));
                        ClientReference.showChatMessage(String.format("Entity UUID: %s", entityUUID), new Object[0]);
                    }
                }
            } else if (args[1].equals("-item") && args.length == 4 && args[2].equals("-to-json")) {
                if (ClientReference.getClientPlayer().func_184614_ca() != ItemStack.field_190927_a) {
                    String folder = OxygenHelperCommon.getConfigFolder() + "data/client/core/itemstack/" + args[3] + ".json";
                    Path path = Paths.get(folder, new String[0]);
                    JsonObject stackObject = new JsonObject();
                    stackObject.add("itemstack", (JsonElement)ItemStackWrapper.of(ClientReference.getClientPlayer().func_184614_ca()).toJson());
                    try {
                        if (!Files.exists(path, new LinkOption[0])) {
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        }
                        JsonUtils.createExternalJsonFile(folder, (JsonElement)stackObject);
                    }
                    catch (IOException exception) {
                        OxygenMain.LOGGER.error("[Core] ItemStack JSON serialization failure!", (Throwable)exception);
                    }
                    ClientReference.showChatMessage("oxygen_core.command.oxygenc.itemStackSerialized", ClientReference.getClientPlayer().func_184614_ca().func_82833_r());
                } else {
                    throw new WrongUsageException("Main hand is empty!", new Object[0]);
                }
            }
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-privileges", "-currency", "-notifications", "-settings", "-request", "-entity", "-item"});
        }
        if (args.length >= 3) {
            if (args[1].equals("-privileges")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-management", "-get-value"});
            }
            if (args[1].equals("-currency")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-balance"});
            }
            if (args[1].equals("-settings")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-reload-settings", "-reload-properties"});
            }
            if (args[1].equals("-request")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-accept", "-reject"});
            }
            if (args[1].equals("-entity")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-get-id", "-get-uuid"});
            }
            if (args[1].equals("-item")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-to-json"});
            }
        }
        return Collections.emptyList();
    }
}

