/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.util;

import austeretony.alternateui.util.AlternateUIReference;
import java.util.List;

public class UIUtils {
    public static void divideText(List<String> dest, String text, int maxWidth, int maxHeight, float textScale, int verticalOffset) {
        dest.clear();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean reachedLimit = false;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : text.toCharArray()) {
            if ((UIUtils.getTextHeight(textScale) + (float)verticalOffset) * (float)dest.size() >= (float)maxHeight) break;
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                dest.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (UIUtils.getTextWidth(stringBuilder.append(builder.toString()).append(String.valueOf(symbol)).toString(), textScale) <= (float)maxWidth) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    dest.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    dest.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            dest.add(builder.toString());
        }
    }

    public static float getTextWidth(String text, float textScale) {
        return (float)AlternateUIReference.getMinecraft().field_71466_p.func_78256_a(text) * textScale;
    }

    public static float getTextHeight(float textScale) {
        return (float)AlternateUIReference.getMinecraft().field_71466_p.field_78288_b * textScale;
    }
}

