/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.text;

import austeretony.alternateui.screen.core.GUISimpleElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class GUINumberField
extends GUISimpleElement<GUINumberField> {
    protected String typedText;
    protected final boolean decimal;
    protected final boolean positive;
    protected int decimalDigitsAmount;
    protected int maxStringLength;
    protected int lineScrollOffset;
    protected int cursorCounter;
    protected int cursorPosition;
    protected int selectionEnd;
    protected long maxNumber;

    public GUINumberField(int xPosition, int yPosition, int width, int height, long maxNumber, boolean decimal, int decimalDigitsAmount, boolean positive) {
        this.setPosition(xPosition, yPosition);
        this.setSize(width, height);
        this.typedText = "";
        this.maxNumber = maxNumber;
        this.decimal = decimal;
        this.decimalDigitsAmount = decimalDigitsAmount;
        this.positive = positive;
        this.maxStringLength = positive ? String.valueOf(maxNumber).length() + (decimal ? decimalDigitsAmount + 1 : 0) : String.valueOf(Long.MIN_VALUE).length() + (decimal ? decimalDigitsAmount + 1 : 0);
        this.enableFull();
    }

    public void setMaxNumber(long value) {
        this.maxNumber = value;
        this.maxStringLength = this.positive ? String.valueOf(value).length() + (this.decimal ? this.decimalDigitsAmount + 1 : 0) : String.valueOf(Long.MIN_VALUE).length() + (this.decimal ? this.decimalDigitsAmount + 1 : 0);
    }

    public String getTypedText() {
        return this.typedText;
    }

    public long getTypedNumberAsLong() {
        if (this.typedText.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(this.typedText);
    }

    public float getTypedNumberAsFloat() {
        if (this.typedText.isEmpty()) {
            return 0.0f;
        }
        return Float.parseFloat(this.typedText);
    }

    public void setText(String text) {
        this.typedText = text;
        this.setCursorPositionEnd();
    }

    public void reset() {
        this.setText("");
    }

    @Override
    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    private String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.typedText.substring(i, j);
    }

    public void writeText(String text) {
        int l;
        String s1 = "";
        String s2 = this.filterAllowedCharacters(text);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.typedText.length() - (i - this.selectionEnd);
        if (!this.typedText.isEmpty()) {
            s1 = s1 + this.typedText.substring(0, i);
        }
        if (k < s2.length()) {
            s1 = s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (!this.typedText.isEmpty() && j < this.typedText.length()) {
            s1 = s1 + this.typedText.substring(j);
        }
        this.typedText = s1;
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    private boolean isAllowedCharacter(char character) {
        return character == '-' || character == '0' || character == '1' || character == '2' || character == '3' || character == '4' || character == '5' || character == '6' || character == '7' || character == '8' || character == '9' || character == '.';
    }

    private String filterAllowedCharacters(String input) {
        String str;
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            String[] array;
            if (!this.isAllowedCharacter(c)) continue;
            if (c == '-' ? this.positive || !this.typedText.isEmpty() : (c == '.' ? !this.decimal || this.typedText.isEmpty() || this.typedText.contains(".") : (this.typedText.contains(".") ? (array = this.typedText.split("[.]")).length == 2 && array[1].length() == this.decimalDigitsAmount : this.typedText.startsWith("0")))) break;
            builder.append(c);
        }
        if ((str = this.typedText + builder.toString()).isEmpty()) {
            str = "0";
        }
        if (str.length() == 1 && str.startsWith("-")) {
            str = "0";
        }
        if (this.decimal) {
            float value = 0.0f;
            try {
                value = Float.parseFloat(str);
            }
            catch (NumberFormatException exception) {
                exception.printStackTrace();
            }
            return this.maxNumber == Long.MAX_VALUE || value <= (float)this.maxNumber ? builder.toString() : "";
        }
        long value = 0L;
        try {
            value = Long.parseLong(str);
        }
        catch (NumberFormatException exception) {
            exception.printStackTrace();
        }
        return this.maxNumber == Long.MAX_VALUE || value <= this.maxNumber ? builder.toString() : "";
    }

    private void deleteWords(int index) {
        if (this.typedText.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(index) - this.cursorPosition);
            }
        }
    }

    private void deleteFromCursor(int index) {
        if (this.typedText.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = index < 0;
                int j = flag ? this.cursorPosition + index : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + index;
                String s = "";
                if (j >= 0) {
                    s = this.typedText.substring(0, j);
                }
                if (k < this.typedText.length()) {
                    s = s + this.typedText.substring(k);
                }
                this.typedText = s;
                if (flag) {
                    this.moveCursorBy(index);
                }
            }
        }
    }

    private int getNthWordFromCursor(int index) {
        return this.getNthWordFromPos(index, this.getCursorPosition());
    }

    private int getNthWordFromPos(int index1, int index2) {
        return this.getWord(index1, this.getCursorPosition(), true);
    }

    private int getWord(int index1, int index2, boolean flag) {
        int k = index2;
        boolean flag1 = index1 < 0;
        int l = Math.abs(index1);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (flag && k > 0 && this.typedText.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.typedText.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.typedText.length();
            if ((k = this.typedText.indexOf(32, k)) == -1) {
                k = j1;
                continue;
            }
            while (flag && k < j1 && this.typedText.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    protected void moveCursorBy(int offset) {
        this.setCursorPosition(this.selectionEnd + offset);
    }

    private void setCursorPosition(int index) {
        this.cursorPosition = index;
        int i = this.typedText.length();
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
        this.setSelectionPos(this.cursorPosition);
    }

    private void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    protected void setCursorPositionEnd() {
        this.setCursorPosition(this.typedText.length());
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        if (!this.isDragged()) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            if (this.isEnabled()) {
                this.writeText(GuiScreen.func_146277_j());
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.isEnabled()) {
                this.writeText("");
            }
            return true;
        }
        switch (keyCode) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled()) {
                        this.deleteWords(-1);
                    }
                } else if (this.isEnabled()) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.typedText.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled()) {
                        this.deleteWords(1);
                    }
                } else if (this.isEnabled()) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (this.isAllowedCharacter(keyChar)) {
            if (this.isEnabled()) {
                this.writeText(Character.toString(keyChar));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = false;
        if (this.isDoubleClickRequired()) {
            if (this.isClickedLately()) {
                flag = true;
                this.setLastClickTime(0L);
            } else {
                this.setLastClickTime(Minecraft.func_71386_F());
            }
        } else {
            flag = true;
        }
        if (flag && this.isEnabled()) {
            this.setDragged(this.isHovered());
            if (this.isDragged() && this.shouldCancelDraggedLogic()) {
                GUINumberField.resetDragged();
            }
            if (this.isDragged() && this.isHovered()) {
                int l = (int)((1.0f + this.getScale()) * (float)(mouseX - this.getX())) - 2;
                String s = this.mc.field_71466_p.func_78269_a(this.typedText.substring(this.lineScrollOffset), this.getWidth() - 6);
                this.setCursorPosition(this.mc.field_71466_p.func_78269_a(s, l).length() + this.lineScrollOffset);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            if (this.isDynamicBackgroundEnabled()) {
                if (this.isEnabled()) {
                    GUINumberField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledBackgroundColor());
                } else {
                    GUINumberField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getDisabledBackgroundColor());
                }
                if (this.isDragged()) {
                    GUINumberField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getHoveredBackgroundColor());
                }
            }
            int i = this.isEnabled() ? this.getEnabledTextColor() : this.getDisabledTextColor();
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 1.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int o = (int)((float)this.getWidth() * (1.0f + this.getTextScale()));
            String s = this.mc.field_71466_p.func_78269_a(this.typedText.substring(this.lineScrollOffset), o);
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isDragged() && this.cursorCounter / 6 % 2 == 0 && flag;
            int l = this.isDynamicBackgroundEnabled() ? 2 : 0;
            int i1 = this.isDynamicBackgroundEnabled() ? (this.getHeight() - this.textHeight(this.getTextScale())) / 2 : 0;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (s.length() > 0) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.mc.field_71466_p.func_175065_a(s1, (float)l, (float)i1, i, this.isTextShadowEnabled());
            }
            if (this.hasDisplayText() && !this.isDragged() && this.getTypedText().isEmpty()) {
                this.mc.field_71466_p.func_175065_a(this.getDisplayText(), (float)l, (float)i1, this.getEnabledTextColor(), this.isTextShadowEnabled());
            }
            boolean flag2 = this.cursorPosition < this.typedText.length() || this.typedText.length() >= this.maxStringLength;
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.getWidth() : l;
            } else if (flag2) {
                k1 = j1 - 1;
                ++j1;
            }
            if (s.length() > 0 && flag && j < s.length()) {
                this.mc.field_71466_p.func_175065_a(s.substring(j), (float)j1, (float)i1, i, this.isTextShadowEnabled());
            }
            if (flag1) {
                if (flag2) {
                    GUINumberField.drawRect(k1, i1 - 2, k1 + 1, i1 + this.mc.field_71466_p.field_78288_b - 1, -3092272);
                } else {
                    GUINumberField.drawRect(k1, i1 - 2, k1 + 1, i1 + this.mc.field_71466_p.field_78288_b - 1, -3092272);
                }
            }
            if (k != j) {
                int l1 = l + this.mc.field_71466_p.func_78256_a(s.substring(0, k));
                this.drawSelectionBox(k1, i1 - 2, l1 - 2, i1 + this.mc.field_71466_p.field_78288_b - 1);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    private void drawSelectionBox(int xStart, int yStart, int xEnd, int yEnd) {
        int i1;
        if (xStart < xEnd) {
            i1 = xStart;
            xStart = xEnd;
            xEnd = i1;
        }
        if (yStart < yEnd) {
            i1 = yStart;
            yStart = yEnd;
            yEnd = i1;
        }
        int j = (int)((float)this.getWidth() * (1.0f + this.getTextScale()));
        if (xEnd > this.getX() + j) {
            xEnd = this.getX() + j;
        }
        if (xStart > this.getX() + j) {
            xStart = this.getX() + j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)xStart, (double)yEnd, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xEnd, (double)yStart, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)xStart, (double)yStart, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public GUINumberField setDragged(boolean isDragged) {
        super.setDragged(isDragged);
        if (!this.isCanNotBeDragged()) {
            this.cursorCounter = 0;
        }
        return this;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    private void setSelectionPos(int index) {
        int i = this.typedText.length();
        if (index > i) {
            index = i;
        }
        if (index < 0) {
            index = 0;
        }
        this.selectionEnd = index;
        if (this.mc.field_71466_p != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = (int)((float)this.getWidth() * (1.0f + this.getTextScale()));
            String s = this.mc.field_71466_p.func_78269_a(this.typedText.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (index == this.lineScrollOffset) {
                this.lineScrollOffset -= this.mc.field_71466_p.func_78262_a(this.typedText, j, true).length();
            }
            if (index > k) {
                this.lineScrollOffset += index - k;
            } else if (index <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - index;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }
}

