/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.core;

import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.util.AlternateUIReference;
import austeretony.alternateui.util.EnumGUIAlignment;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GUISimpleElement<T extends GUIBaseElement>
extends GUIBaseElement<T> {
    public static final int FONT_HEIGHT = 9;
    private boolean isDebugMode;
    private boolean isStatBackgroundEnabled;
    private boolean isDynBackgroundEnabled;
    private boolean isTextShadowEnabled;
    private boolean hasTooltip;
    private boolean hasDisplayText;
    private String displayText;
    private String tooltipText;
    private EnumGUIAlignment textAlignment = EnumGUIAlignment.CENTER;
    private int textOffset;
    private int tooltipWidth;
    private int debugColor = 1694433500;
    private int statBackgroundColor = -12566464;
    private int enabledColor = -5921371;
    private int disabledColor = -10066330;
    private int hoveredColor = -4210753;
    private int enabledBackgroundColor = -11184811;
    private int disabledBackgroundColor = -12566464;
    private int hoveredBackgroundColor = -11513776;
    private int enabledTextColor = -3026479;
    private int disabledTextColor = -9408400;
    private int hoveredTextColor = -855310;
    private int tooltipBackgroundColor = -12566464;
    private int tooltipTextColor = -3026479;
    private float mainScaleFactor = 1.0f;
    private float textScaleFactor = 1.0f;
    private float tooltipScaleFactor = 1.0f;
    protected RenderItem itemRender = AlternateUIReference.getRenderItem();

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDebugMode()) {
                GUISimpleElement.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getDebugColor());
            }
            if (this.isStaticBackgroundEnabled()) {
                GUISimpleElement.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getStaticBackgroundColor());
            } else if (this.isDynamicBackgroundEnabled()) {
                int color = !this.isEnabled() ? this.getDisabledBackgroundColor() : (this.isHovered() || this.isToggled() ? this.getHoveredBackgroundColor() : this.getEnabledBackgroundColor());
                GUISimpleElement.drawRect(0, 0, this.getWidth(), this.getHeight(), color);
            }
            if (this.hasDisplayText()) {
                int textOffset = this.getTextAlignment() == EnumGUIAlignment.CENTER ? (this.getWidth() - this.textWidth(this.getDisplayText(), this.getTextScale())) / 2 + this.getTextOffset() : (this.getTextAlignment() == EnumGUIAlignment.LEFT ? 0 + this.getTextOffset() : this.getWidth() - this.textWidth(this.getDisplayText(), this.getTextScale()) - this.getTextOffset());
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)textOffset, (float)((this.getHeight() - this.textHeight(this.getTextScale())) / 2), (float)0.0f);
                GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
                int color = !this.isEnabled() ? this.getDisabledTextColor() : (this.isHovered() || this.isToggled() ? this.getHoveredTextColor() : this.getEnabledTextColor());
                this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, color, this.isTextShadowEnabled());
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isHovered() && this.hasTooltip()) {
            int width = (int)((float)this.tooltipWidth * this.tooltipScaleFactor);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(mouseX + this.screen.guiLeft + width >= this.screen.field_146294_l ? (float)(mouseX - width) : (float)mouseX), (float)((float)mouseY - 11.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.tooltipScaleFactor, (float)this.tooltipScaleFactor, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GUISimpleElement.drawRect(0, 0, this.tooltipWidth, 11, this.tooltipBackgroundColor);
            this.mc.field_71466_p.func_78276_b(this.tooltipText, 2, 2, this.tooltipTextColor);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + (int)((float)this.getWidth() * this.getScale()) && mouseY < this.getY() + (int)((float)this.getHeight() * this.getScale()));
    }

    public T debugMode() {
        this.isDebugMode = true;
        return (T)this;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isTextShadowEnabled() {
        return this.isTextShadowEnabled;
    }

    public T enableTextShadow() {
        this.isTextShadowEnabled = true;
        return (T)this;
    }

    public boolean isDynamicBackgroundEnabled() {
        return this.isDynBackgroundEnabled;
    }

    public boolean isStaticBackgroundEnabled() {
        return this.isStatBackgroundEnabled;
    }

    public T enableDynamicBackground() {
        this.isDynBackgroundEnabled = true;
        return (T)this;
    }

    public T enableDynamicBackground(int enabledColorHex, int disabledColorHex, int hoveredColorHex) {
        this.enableDynamicBackground();
        this.enabledBackgroundColor = enabledColorHex;
        this.disabledBackgroundColor = disabledColorHex;
        this.hoveredBackgroundColor = hoveredColorHex;
        return (T)this;
    }

    public T enableStaticBackground() {
        this.isStatBackgroundEnabled = true;
        return (T)this;
    }

    public T enableStaticBackground(int colorHex) {
        this.enableStaticBackground();
        this.statBackgroundColor = colorHex;
        return (T)this;
    }

    public T initTooltip(String text) {
        this.tooltipText = text;
        this.tooltipWidth = this.textWidth(text, 1.0f) + 4;
        this.hasTooltip = true;
        return (T)this;
    }

    public T initTooltip(String text, float scale) {
        this.tooltipText = text;
        this.tooltipScaleFactor = scale;
        this.tooltipWidth = this.textWidth(text, 1.0f) + 4;
        this.hasTooltip = true;
        return (T)this;
    }

    public T initTooltip(String text, int textColorHex, int backgroundColorHex, float scale) {
        this.tooltipText = text;
        this.tooltipScaleFactor = scale;
        this.tooltipWidth = this.textWidth(text, 1.0f) + 4;
        this.tooltipTextColor = textColorHex;
        this.tooltipBackgroundColor = backgroundColorHex;
        this.hasTooltip = true;
        return (T)this;
    }

    public boolean hasTooltip() {
        return this.hasTooltip;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String text) {
        this.tooltipText = text;
    }

    public float getTooltipScaleFactor() {
        return this.tooltipScaleFactor;
    }

    public void setTooltipScaleFactor(float scale) {
        this.tooltipScaleFactor = scale;
    }

    public int getTooltipWidth() {
        return this.tooltipWidth;
    }

    public void setTooltipWidth(int width) {
        this.tooltipWidth = width;
    }

    public int getTooltipTextColor() {
        return this.tooltipTextColor;
    }

    public void setTooltipTextColor(int colorHex) {
        this.tooltipTextColor = colorHex;
    }

    public int getTooltipBackgroundColor() {
        return this.tooltipBackgroundColor;
    }

    public void setTooltipBackgroundColor(int colorHex) {
        this.tooltipBackgroundColor = colorHex;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public boolean hasDisplayText() {
        return this.hasDisplayText;
    }

    public T setDisplayText(String displayText) {
        this.hasDisplayText = true;
        this.displayText = displayText;
        return (T)this;
    }

    public T setDisplayText(String displayText, boolean enableShadow) {
        this.setDisplayText(displayText);
        this.isTextShadowEnabled = enableShadow;
        return (T)this;
    }

    public T setDisplayText(String displayText, boolean enableShadow, float textScale) {
        this.setDisplayText(displayText, enableShadow);
        this.textScaleFactor = textScale;
        return (T)this;
    }

    public int getDebugColor() {
        return this.debugColor;
    }

    public T setDebugColor(int colorHex) {
        this.debugColor = colorHex;
        return (T)this;
    }

    public int getEnabledColor() {
        return this.enabledColor;
    }

    public T setEnabledColor(int colorHex) {
        this.enabledColor = colorHex;
        return (T)this;
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public T setDisabledColor(int colorHex) {
        this.disabledColor = colorHex;
        return (T)this;
    }

    public int getHoveredColor() {
        return this.hoveredColor;
    }

    public T setHoveredColor(int colorHex) {
        this.hoveredColor = colorHex;
        return (T)this;
    }

    public int getStaticBackgroundColor() {
        return this.statBackgroundColor;
    }

    public T setStaticBackgroundColor(int colorHex) {
        this.statBackgroundColor = colorHex;
        return (T)this;
    }

    public T setDynamicBackgroundColor(int enabledColorHex, int disabledColorHex, int hoveredColorHex) {
        this.enabledBackgroundColor = enabledColorHex;
        this.disabledBackgroundColor = disabledColorHex;
        this.hoveredBackgroundColor = hoveredColorHex;
        return (T)this;
    }

    public int getEnabledBackgroundColor() {
        return this.enabledBackgroundColor;
    }

    public T setEnabledBackgroundColor(int colorHex) {
        this.enabledBackgroundColor = colorHex;
        return (T)this;
    }

    public int getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public T setDisabledBackgroundColor(int colorHex) {
        this.disabledBackgroundColor = colorHex;
        return (T)this;
    }

    public int getHoveredBackgroundColor() {
        return this.hoveredBackgroundColor;
    }

    public T setHoveredBackgroundColor(int colorHex) {
        this.hoveredBackgroundColor = colorHex;
        return (T)this;
    }

    public int getEnabledTextColor() {
        return this.enabledTextColor;
    }

    public T setTextDynamicColor(int enabledTextColorHex, int disabledTextColorHex, int hoveredTextColorHex) {
        this.enabledTextColor = enabledTextColorHex;
        this.disabledTextColor = disabledTextColorHex;
        this.hoveredTextColor = hoveredTextColorHex;
        return (T)this;
    }

    public T setEnabledTextColor(int colorHex) {
        this.enabledTextColor = colorHex;
        return (T)this;
    }

    public int getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public T setDisabledTextColor(int colorHex) {
        this.disabledTextColor = colorHex;
        return (T)this;
    }

    public int getHoveredTextColor() {
        return this.hoveredTextColor;
    }

    public T setHoveredTextColor(int colorHex) {
        this.hoveredTextColor = colorHex;
        return (T)this;
    }

    public float getScale() {
        return this.mainScaleFactor;
    }

    public float getTextScale() {
        return this.textScaleFactor;
    }

    public T setScale(float scaleFactor) {
        this.mainScaleFactor = scaleFactor;
        return (T)this;
    }

    public T setTextScale(float scaleFactor) {
        this.textScaleFactor = scaleFactor;
        return (T)this;
    }

    public EnumGUIAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public int getTextOffset() {
        return this.textOffset;
    }

    public T setTextAlignment(EnumGUIAlignment textAlignment, int offset) {
        this.textAlignment = textAlignment;
        this.textOffset = offset;
        return (T)this;
    }

    public int textWidth(String text, float scaleFactor) {
        return (int)((float)this.mc.field_71466_p.func_78256_a(text) * scaleFactor);
    }

    public int textHeight(float scaleFactor) {
        return (int)((float)this.mc.field_71466_p.field_78288_b * scaleFactor);
    }

    public T disableFull() {
        this.setEnabled(false);
        this.setVisible(false);
        return (T)this;
    }

    public T enableFull() {
        this.setEnabled(true);
        this.setVisible(true);
        return (T)this;
    }

    public T enableFull(boolean flag) {
        this.setEnabled(flag);
        this.setVisible(flag);
        return (T)this;
    }

    public static void drawRect(int xStart, int yStart, int xEnd, int yEnd, int color) {
        int j1;
        if (xStart < xEnd) {
            j1 = xStart;
            xStart = xEnd;
            xEnd = j1;
        }
        if (yStart < yEnd) {
            j1 = yStart;
            yStart = yEnd;
            yEnd = j1;
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b((double)xStart, (double)yEnd, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)xEnd, (double)yStart, 0.0).func_181675_d();
        bufferBuilder.func_181662_b((double)xStart, (double)yStart, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawGradientRect(int xStart, int yStart, int xEnd, int yEnd, int colorDec1, int colorDec2) {
        float alpha1 = (float)(colorDec1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(colorDec1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colorDec1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(colorDec1 & 0xFF) / 255.0f;
        float alpha2 = (float)(colorDec2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(colorDec2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(colorDec2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(colorDec2 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b((double)xStart, (double)yEnd, 0.0).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        bufferBuilder.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        bufferBuilder.func_181662_b((double)xEnd, (double)yStart, 0.0).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        bufferBuilder.func_181662_b((double)xStart, (double)yStart, 0.0).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawCircle(int x, int y, int steps, int radius, int color) {
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        bufferBuilder.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        for (double i = 0.0; i <= (double)steps; i += 1.0) {
            double angle = Math.PI * 2 * i / (double)steps + Math.toRadians(180.0);
            bufferBuilder.func_181662_b((double)x + Math.sin(angle) * (double)radius, (double)y + Math.cos(angle) * (double)radius, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircle(int x, int y, int steps, int innerRadius, int outerRadius, int color) {
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        double doublePI = Math.PI * 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (double i = 0.0; i < (double)steps; i += 1.0) {
            double angle1 = doublePI / (double)steps;
            double angle2 = i * angle1 + doublePI * 2.0 - doublePI / 2.0;
            bufferBuilder.func_181662_b((double)x + Math.sin(angle2) * (double)outerRadius, (double)y + Math.cos(angle2) * (double)outerRadius, 0.0).func_181675_d();
            bufferBuilder.func_181662_b((double)x + Math.sin(angle2 + angle1) * (double)outerRadius, (double)y + Math.cos(angle2 + angle1) * (double)outerRadius, 0.0).func_181675_d();
            bufferBuilder.func_181662_b((double)x + Math.sin(angle2 + angle1) * (double)innerRadius, (double)y + Math.cos(angle2 + angle1) * (double)innerRadius, 0.0).func_181675_d();
            bufferBuilder.func_181662_b((double)x + Math.sin(angle2) * (double)innerRadius, (double)y + Math.cos(angle2) * (double)innerRadius, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

