/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.container.framework;

import austeretony.alternateui.container.core.AbstractGUIContainer;
import austeretony.alternateui.container.framework.AbstractGUISorter;
import austeretony.alternateui.container.framework.GUIContainerSlots;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUISlotsPosition;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GUISlotsFramework
extends GUISimpleElement<GUISlotsFramework> {
    public final EnumGUISlotsPosition slotsPosition;
    public final Container container;
    public final int firstSlotIndex;
    public final int lastSlotIndex;
    public final int rows;
    public final int columns;
    public final int visibleSlots;
    private int slotsDistanceHorizontal;
    private int slotsDistanceVertical;
    private boolean slotBottom;
    private boolean forceUpdate;
    private boolean isTooltipsDisabled;
    public final GUIContainerSlots slots = new GUIContainerSlots(this);
    private int slotBottomLayerColor = 0x30000000;
    private int slotHighlightingColor = 0x30FFFFFF;

    public GUISlotsFramework(EnumGUISlotsPosition slotsPosition, Container container, int firstSlotIndex, int lastSlotIndex, int rows, int columns) {
        this.slotsPosition = slotsPosition;
        this.container = container;
        this.firstSlotIndex = firstSlotIndex;
        this.lastSlotIndex = lastSlotIndex;
        this.rows = rows;
        this.columns = columns;
        this.visibleSlots = rows * columns == 0 ? lastSlotIndex - firstSlotIndex : rows * columns;
        this.slotsDistanceHorizontal = 2;
        this.slotsDistanceVertical = 2;
        this.setSize(this.columns * (this.getSlotWidth() + this.slotsDistanceHorizontal), this.rows * (this.getSlotHeight() + this.slotsDistanceVertical));
        this.enableFull();
    }

    public void updateFramework(AbstractGUISorter sorter) {
        int k;
        int size;
        Slot slotCopy;
        Slot slot;
        int i;
        this.slots.visibleSlots.clear();
        this.slots.visibleSlotsIndexes.clear();
        this.slots.slotsBuffer.clear();
        this.slots.indexesBuffer.clear();
        this.slots.searchSlots.clear();
        this.slots.searchIndexes.clear();
        this.slots.items.clear();
        this.slots.setCurrentSorter(sorter);
        if (this.slots.hasScroller()) {
            this.slots.getScroller().reset();
        }
        for (i = this.firstSlotIndex; i <= this.lastSlotIndex; ++i) {
            if (i >= this.container.field_75151_b.size()) continue;
            slot = (Slot)this.container.field_75151_b.get(i);
            slotCopy = this.copySlot(slot);
            size = this.slots.visibleSlots.size();
            if (!sorter.isSlotValid(slotCopy)) continue;
            if (slotCopy.func_75216_d()) {
                this.slots.items.put(size, slotCopy.func_75211_c());
            }
            if (this.slotsPosition == EnumGUISlotsPosition.CUSTOM) {
                k = size / this.columns;
                slotCopy.field_75223_e = this.getX() + size * (this.getSlotWidth() + this.getSlotDistanceHorizontal()) - k * ((this.getSlotWidth() + this.getSlotDistanceHorizontal()) * this.columns);
                slotCopy.field_75221_f = this.getY() + k * (this.getSlotHeight() + this.getSlotDistanceVertical()) - size / this.visibleSlots * (this.rows * (this.getSlotHeight() + this.getSlotDistanceVertical()));
            }
            this.slots.visibleSlots.add(slotCopy);
            this.slots.visibleSlotsIndexes.add(i);
            this.slots.slotsBuffer.add(slotCopy);
            this.slots.indexesBuffer.add(i);
        }
        if (sorter.shouldAddEmptySlotsAfter()) {
            i = this.firstSlotIndex;
            for (i = this.firstSlotIndex; i <= this.lastSlotIndex; ++i) {
                if (i >= this.container.field_75151_b.size() || (slotCopy = this.copySlot(slot = (Slot)this.container.field_75151_b.get(i))).func_75216_d()) continue;
                size = this.slots.visibleSlots.size();
                if (this.slotsPosition == EnumGUISlotsPosition.CUSTOM) {
                    k = size / this.columns;
                    slotCopy.field_75223_e = this.getX() + size * (this.getSlotWidth() + this.getSlotDistanceHorizontal()) - k * ((this.getSlotWidth() + this.getSlotDistanceHorizontal()) * this.columns);
                    slotCopy.field_75221_f = this.getY() + k * (this.getSlotHeight() + this.getSlotDistanceVertical()) - size / this.visibleSlots * (this.rows * (this.getSlotHeight() + this.getSlotDistanceVertical()));
                }
                this.slots.visibleSlots.add(slotCopy);
                this.slots.visibleSlotsIndexes.add(i);
                this.slots.slotsBuffer.add(slotCopy);
                this.slots.indexesBuffer.add(i);
            }
        }
    }

    public void updateFramework() {
        this.updateFramework(GUIContainerSlots.BASE_SORTER);
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight());
        if (this.slots.hasScroller() && this.slots.getScroller().hasSlider() && (this.slots.hasSearchField() && !this.slots.getSearchField().isDragged() || !this.slots.hasSearchField())) {
            this.slots.getScroller().getSlider().mouseOver(mouseX, mouseY);
            this.slots.getScroller().getSlider().mouseClicked(mouseX, mouseY, 0);
            ((AbstractGUIContainer)this.screen).handleFrameworkSlidebar(this, mouseY);
        }
        if (this.slots.hasSearchField()) {
            this.slots.getSearchField().mouseOver(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isEnabled() && mouseButton == 0 && this.slots.hasSearchField()) {
            this.slots.getSearchField().mouseClicked(mouseX, mouseY, 1);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            if (this.slots.hasScroller() && this.slots.getScroller().hasSlider()) {
                this.slots.getScroller().getSlider().draw(mouseX, mouseY);
            }
            if (this.slots.hasSearchField()) {
                this.slots.getSearchField().draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        if (this.isEnabled() && this.slots.hasSearchField() && this.slots.getSearchField().keyTyped(typedChar, keyCode)) {
            if (this.slots.getSearchField().getTypedText().toLowerCase().length() > 0) {
                this.updateSearchResult(this);
            } else {
                this.updateFramework(this.slots.getCurrentSorter());
            }
            if (this.slots.hasScroller()) {
                this.slots.getScroller().reset();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    protected void updateSearchResult(GUISlotsFramework framework) {
        String typedText = framework.slots.getSearchField().getTypedText().toLowerCase();
        Iterator<Integer> itemsIterator = framework.slots.items.keySet().iterator();
        framework.slots.visibleSlots.clear();
        framework.slots.visibleSlotsIndexes.clear();
        framework.slots.searchSlots.clear();
        framework.slots.searchIndexes.clear();
        while (itemsIterator.hasNext()) {
            String itemName;
            int slotIndex = itemsIterator.next();
            ItemStack itemStack = framework.slots.items.get(slotIndex);
            if (itemStack == null || !(itemName = itemStack.func_82833_r().toLowerCase()).startsWith(typedText) && !itemName.contains(" " + typedText)) continue;
            int size = framework.slots.searchSlots.size();
            Slot slotCopy = this.copySlot(framework.slots.slotsBuffer.get(slotIndex));
            if (framework.slotsPosition == EnumGUISlotsPosition.CUSTOM) {
                int k = size / framework.columns;
                slotCopy.field_75223_e = framework.getX() + size * (framework.getSlotWidth() + framework.getSlotDistanceHorizontal()) - k * ((framework.getSlotWidth() + framework.getSlotDistanceHorizontal()) * framework.columns);
                slotCopy.field_75221_f = framework.getY() + k * (framework.getSlotHeight() + framework.getSlotDistanceVertical()) - size / framework.visibleSlots * (framework.rows * (framework.getSlotHeight() + framework.getSlotDistanceVertical()));
            }
            framework.slots.visibleSlots.add(slotCopy);
            framework.slots.visibleSlotsIndexes.add(framework.slots.indexesBuffer.get(slotIndex));
            framework.slots.searchSlots.add(slotCopy);
            framework.slots.searchIndexes.add(framework.slots.indexesBuffer.get(slotIndex));
        }
    }

    protected final Slot copySlot(Slot slot) {
        return new Slot(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
    }

    @Override
    public void update() {
        if (this.slots.hasSearchField()) {
            this.slots.getSearchField().updateCursorCounter();
        }
    }

    public GUIContainerSlots getSlots() {
        return this.slots;
    }

    public List<Slot> getSlotsList() {
        return this.slots.slotsBuffer;
    }

    @Override
    public GUISlotsFramework setPosition(int xPosition, int yPosition) {
        if (this.slotsPosition == EnumGUISlotsPosition.CUSTOM) {
            super.setPosition(xPosition, yPosition);
        }
        return this;
    }

    public void setSlotDistance(int slotsDistanceHorizontal, int slotsDistanceVertical) {
        this.slotsDistanceHorizontal = slotsDistanceHorizontal;
        this.slotsDistanceVertical = slotsDistanceVertical;
        this.setSize(this.columns * (this.getSlotWidth() + slotsDistanceHorizontal), this.rows * (this.getSlotHeight() + slotsDistanceVertical));
    }

    public int getSlotDistanceHorizontal() {
        return this.slotsDistanceHorizontal;
    }

    public int getSlotDistanceVertical() {
        return this.slotsDistanceVertical;
    }

    public boolean isSlotBottomLayerEnabled() {
        return this.slotBottom;
    }

    public GUISlotsFramework enableSlotBottomLayer() {
        this.slotBottom = true;
        return this;
    }

    public int getSlotBottomLayerColor() {
        return this.slotBottomLayerColor;
    }

    public GUISlotsFramework setSlotBottomLayerColor(int colorHex) {
        this.slotBottomLayerColor = colorHex;
        return this;
    }

    public int getSlotHighlightingColor() {
        return this.slotHighlightingColor;
    }

    public GUISlotsFramework setSlotHighlightingColor(int colorHex) {
        this.slotHighlightingColor = colorHex;
        return this;
    }

    public int getSlotWidth() {
        return 16;
    }

    public int getSlotHeight() {
        return 16;
    }

    public boolean getForcedToUpdate() {
        return this.forceUpdate;
    }

    public GUISlotsFramework forceUpdateOnEveryClick() {
        this.forceUpdate = true;
        return this;
    }

    public boolean getTooltipsDisabled() {
        return this.isTooltipsDisabled;
    }

    public GUISlotsFramework disableTooltips() {
        this.isTooltipsDisabled = true;
        return this;
    }
}

