/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.container.core;

import austeretony.alternateui.container.framework.GUISlotsFramework;
import austeretony.alternateui.screen.browsing.GUIScroller;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUISlotsPosition;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public abstract class AbstractGUIContainer
extends AbstractGUIScreen {
    public Container container;
    protected final Set<Slot> dragSplittingSlots = Sets.newHashSet();
    private Slot hoveredSlot;
    private Slot clickedSlot;
    private Slot returningStackDestSlot;
    private Slot currentDragTargetSlot;
    private Slot lastClickSlot;
    private boolean isRightMouseClick;
    private boolean doubleClick;
    private boolean ignoreMouseUp;
    protected boolean dragSplitting;
    private ItemStack draggedStack = ItemStack.field_190927_a;
    private ItemStack returningStack = ItemStack.field_190927_a;
    private ItemStack shiftClickedSlot = ItemStack.field_190927_a;
    private int touchUpX;
    private int touchUpY;
    private int dragSplittingLimit;
    private int dragSplittingButton;
    private int dragSplittingRemnant;
    private int lastClickButton;
    private int yPrevMouse;
    private long returningStackTime;
    private long dragItemDropDelay;
    private long lastClickTime;

    public AbstractGUIContainer(Container container) {
        this.container = container;
        this.ignoreMouseUp = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.container;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.hoveredSlot = null;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
        ItemStack itemstack = this.draggedStack.func_190926_b() ? inventoryplayer.func_70445_o() : this.draggedStack;
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        if (!itemstack.func_190926_b()) {
            int j2 = 8;
            int k2 = this.draggedStack.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.draggedStack.func_190926_b() && this.isRightMouseClick) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.dragSplitting && this.dragSplittingSlots.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.dragSplittingRemnant);
                if (itemstack.func_190926_b()) {
                    s = "" + TextFormatting.YELLOW + "0";
                }
            }
            this.drawItemStack(itemstack, mouseX - this.guiLeft - 8, mouseY - this.guiTop - k2, s);
        }
        if (!this.returningStack.func_190926_b()) {
            float f = (float)(Minecraft.func_71386_F() - this.returningStackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.returningStack = ItemStack.field_190927_a;
            }
            int l2 = this.returningStackDestSlot.field_75223_e - this.touchUpX;
            int i3 = this.returningStackDestSlot.field_75221_f - this.touchUpY;
            int l1 = this.touchUpX + (int)((float)l2 * f);
            int i2 = this.touchUpY + (int)((float)i3 * f);
            this.drawItemStack(this.returningStack, l1, i2, null);
        }
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        this.renderHoveredToolTip(mouseX, mouseY);
        this.yPrevMouse = mouseY;
    }

    @Override
    protected void drawSlots(int mouseX, int mouseY) {
        for (GUISlotsFramework framework : this.getWorkspace().getCurrentSection().getSlotsFrameworks()) {
            if (!framework.isVisible()) continue;
            for (int i = 0; i < framework.visibleSlots; ++i) {
                if (i >= framework.slots.visibleSlots.size()) continue;
                Slot slot = framework.slots.visibleSlots.get(i);
                if (framework.isSlotBottomLayerEnabled()) {
                    RenderHelper.func_74518_a();
                    this.drawSlotBottomLayer(slot, framework);
                    RenderHelper.func_74519_b();
                }
                RenderHelper.func_74520_c();
                this.drawSlot(slot, framework);
                if (this.getWorkspace().getCurrentSection().hasCurrentCallback() || !this.isMouseOverSlot(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
                this.drawSlotHighlighting(slot, framework);
            }
        }
    }

    protected void drawSlotBottomLayer(Slot slot, GUISlotsFramework framework) {
        AbstractGUIContainer.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + framework.getSlotWidth()), (int)(slot.field_75221_f + framework.getSlotHeight()), (int)framework.getSlotBottomLayerColor());
    }

    protected void drawSlotHighlighting(Slot slot, GUISlotsFramework framework) {
        this.hoveredSlot = slot;
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        int j = slot.field_75223_e;
        int k = slot.field_75221_f;
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GUISimpleElement.drawRect(j, k, j + 16, k + 16, framework.getSlotHighlightingColor());
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    private void drawSlot(Slot slot, GUISlotsFramework framework) {
        TextureAtlasSprite textureatlassprite;
        int i = slot.field_75223_e;
        int j = slot.field_75221_f;
        ItemStack itemstack = slot.func_75211_c();
        boolean flag = false;
        boolean flag1 = slot == this.clickedSlot && !this.draggedStack.func_190926_b() && !this.isRightMouseClick;
        ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slot == this.clickedSlot && !this.draggedStack.func_190926_b() && this.isRightMouseClick && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.dragSplitting && this.dragSplittingSlots.contains(slot) && !itemstack1.func_190926_b()) {
            if (this.dragSplittingSlots.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slot, (ItemStack)itemstack1, (boolean)true) && this.container.func_94531_b(slot)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(this.dragSplittingSlots, (int)this.dragSplittingLimit, (ItemStack)itemstack, (int)(slot.func_75211_c().func_190926_b() ? 0 : slot.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slot.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.dragSplittingSlots.remove(slot);
                this.updateDragSplitting();
            }
        }
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slot.func_111238_b() && (textureatlassprite = slot.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(slot.getBackgroundLocation());
            this.func_175175_a(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                AbstractGUIContainer.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, itemstack, i, j);
            this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, i, j, s);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    public void handleFrameworkSlidebar(GUISlotsFramework framework, int mouseY) {
        if (framework.slots.getScroller().getSlider().isDragged()) {
            int slidebarOffset = mouseY - framework.slots.getScroller().getSlider().getSlidebarY();
            float sliderActiveHeight = framework.slots.getScroller().getSlider().getHeight() - framework.slots.getScroller().getSlider().getSlidebarHeight();
            float currentPosition = mouseY - slidebarOffset - this.yPrevMouse + mouseY + this.guiTop;
            framework.slots.getScroller().setPosition((int)((float)framework.slots.getScroller().getMaxPosition() * ((currentPosition - (float)framework.slots.getScroller().getSlider().getY()) / sliderActiveHeight)));
            framework.slots.getScroller().getSlider().handleSlidebarViaCursor((int)(sliderActiveHeight * (currentPosition / sliderActiveHeight)));
            this.scrollSlots(framework);
        }
    }

    protected void scrollSlots(GUISlotsFramework framework) {
        int i = 0;
        boolean scrollingSearch = !framework.slots.searchSlots.isEmpty();
        framework.slots.visibleSlots.clear();
        framework.slots.visibleSlotsIndexes.clear();
        if (framework.slots.getScroller().scrollerType == GUIScroller.EnumScrollerType.STANDARD) {
            for (i = framework.slots.getScroller().getPosition() * framework.columns; i < framework.slots.getScroller().getPosition() * framework.columns + framework.visibleSlots; ++i) {
                if ((scrollingSearch || i >= framework.slots.slotsBuffer.size()) && (!scrollingSearch || i >= framework.slots.searchSlots.size())) continue;
                Slot slot = scrollingSearch ? framework.slots.searchSlots.get(i) : framework.slots.slotsBuffer.get(i);
                Slot slotCopy = this.copySlot(slot);
                int size = framework.slots.visibleSlots.size();
                if (framework.slotsPosition == EnumGUISlotsPosition.CUSTOM) {
                    int k = size / framework.columns;
                    slotCopy.field_75223_e = framework.getX() + size * (framework.getSlotWidth() + framework.getSlotDistanceHorizontal()) - k * ((framework.getSlotWidth() + framework.getSlotDistanceHorizontal()) * framework.columns);
                    slotCopy.field_75221_f = framework.getY() + k * (framework.getSlotHeight() + framework.getSlotDistanceVertical()) - size / framework.visibleSlots * (framework.rows * (framework.getSlotHeight() + framework.getSlotDistanceVertical()));
                }
                framework.slots.visibleSlots.add(slotCopy);
                framework.slots.visibleSlotsIndexes.add(scrollingSearch ? framework.slots.searchIndexes.get(i) : framework.slots.indexesBuffer.get(i));
            }
        }
    }

    protected final Slot copySlot(Slot slot) {
        return new Slot(slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
    }

    protected void renderHoveredToolTip(int p_191948_1_, int p_191948_2_) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredSlot != null && this.hoveredSlot.func_75216_d()) {
            this.func_146285_a(this.hoveredSlot.func_75211_c(), p_191948_1_, p_191948_2_);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y - (this.draggedStack.func_190926_b() ? 0 : 8), altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
    }

    private void updateDragSplitting() {
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!itemstack.func_190926_b() && this.dragSplitting) {
            if (this.dragSplittingLimit == 2) {
                this.dragSplittingRemnant = itemstack.func_77976_d();
            } else {
                this.dragSplittingRemnant = itemstack.func_190916_E();
                for (Slot slot : this.dragSplittingSlots) {
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    ItemStack itemstack2 = slot.func_75211_c();
                    int i = itemstack2.func_190926_b() ? 0 : itemstack2.func_190916_E();
                    Container.func_94525_a(this.dragSplittingSlots, (int)this.dragSplittingLimit, (ItemStack)itemstack1, (int)i);
                    int j = Math.min(itemstack1.func_77976_d(), slot.func_178170_b(itemstack1));
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.dragSplittingRemnant -= itemstack1.func_190916_E() - i;
                }
            }
        }
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (GUISlotsFramework framework : this.getWorkspace().getCurrentSection().getSlotsFrameworks()) {
            if (!framework.isEnabled()) continue;
            for (int i = 0; i < framework.visibleSlots; ++i) {
                if (i >= framework.slots.visibleSlots.size()) continue;
                Slot slot = framework.slots.visibleSlots.get(i);
                if (this.getWorkspace().getCurrentSection().hasCurrentCallback() || !this.isMouseOverSlot(slot, x, y)) continue;
                return (Slot)this.container.field_75151_b.get(framework.slots.visibleSlotsIndexes.get(i));
            }
        }
        return null;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.getWorkspace().getCurrentSection().hasCurrentCallback()) {
            boolean flag = this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100);
            Slot slot = this.getSlotAtPosition(mouseX, mouseY);
            long i = Minecraft.func_71386_F();
            this.doubleClick = this.lastClickSlot == slot && i - this.lastClickTime < 250L && this.lastClickButton == mouseButton;
            this.ignoreMouseUp = false;
            if (mouseButton == 0 || mouseButton == 1 || flag) {
                int j = this.guiLeft;
                int k = this.guiTop;
                boolean flag1 = this.hasClickedOutside(mouseX, mouseY, j, k);
                if (slot != null) {
                    flag1 = false;
                }
                int l = -1;
                if (slot != null) {
                    l = slot.field_75222_d;
                }
                if (flag1) {
                    l = -999;
                }
                if (this.field_146297_k.field_71474_y.field_85185_A && flag1 && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                    return;
                }
                if (l != -1) {
                    if (this.field_146297_k.field_71474_y.field_85185_A) {
                        if (slot != null && slot.func_75216_d()) {
                            this.clickedSlot = slot;
                            this.draggedStack = ItemStack.field_190927_a;
                            this.isRightMouseClick = mouseButton == 1;
                        } else {
                            this.clickedSlot = null;
                        }
                    } else if (!this.dragSplitting) {
                        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                                this.handleMouseClick(slot, l, mouseButton, ClickType.CLONE);
                            } else {
                                boolean flag2 = l != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                                ClickType clicktype = ClickType.PICKUP;
                                if (flag2) {
                                    this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                                    clicktype = ClickType.QUICK_MOVE;
                                } else if (l == -999) {
                                    clicktype = ClickType.THROW;
                                }
                                this.handleMouseClick(slot, l, mouseButton, clicktype);
                            }
                            this.ignoreMouseUp = true;
                        } else {
                            this.dragSplitting = true;
                            this.dragSplittingButton = mouseButton;
                            this.dragSplittingSlots.clear();
                            if (mouseButton == 0) {
                                this.dragSplittingLimit = 0;
                            } else if (mouseButton == 1) {
                                this.dragSplittingLimit = 1;
                            } else if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                                this.dragSplittingLimit = 2;
                            }
                        }
                    }
                }
            }
            this.lastClickSlot = slot;
            this.lastClickTime = i;
            this.lastClickButton = mouseButton;
        }
        for (GUISlotsFramework framework : this.getWorkspace().getCurrentSection().getSlotsFrameworks()) {
            framework.mouseClicked(mouseX, mouseY, mouseButton);
        }
        this.getWorkspace().getCurrentSection().mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected boolean hasClickedOutside(int p_193983_1_, int p_193983_2_, int p_193983_3_, int p_193983_4_) {
        return p_193983_1_ < p_193983_3_ || p_193983_2_ < p_193983_4_ || p_193983_1_ >= p_193983_3_ + this.xSize || p_193983_2_ >= p_193983_4_ + this.ySize;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.clickedSlot != null && this.field_146297_k.field_71474_y.field_85185_A) {
            if (clickedMouseButton == 0 || clickedMouseButton == 1) {
                if (this.draggedStack.func_190926_b()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.func_75211_c().func_190926_b()) {
                        this.draggedStack = this.clickedSlot.func_75211_c().func_77946_l();
                    }
                } else if (this.draggedStack.func_190916_E() > 1 && slot != null && Container.func_94527_a((Slot)slot, (ItemStack)this.draggedStack, (boolean)false)) {
                    long i = Minecraft.func_71386_F();
                    if (this.currentDragTargetSlot == slot) {
                        if (i - this.dragItemDropDelay > 500L) {
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.handleMouseClick(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.dragItemDropDelay = i + 750L;
                            this.draggedStack.func_190918_g(1);
                        }
                    } else {
                        this.currentDragTargetSlot = slot;
                        this.dragItemDropDelay = i;
                    }
                }
            }
        } else if (this.dragSplitting && slot != null && !itemstack.func_190926_b() && (itemstack.func_190916_E() > this.dragSplittingSlots.size() || this.dragSplittingLimit == 2) && Container.func_94527_a((Slot)slot, (ItemStack)itemstack, (boolean)true) && slot.func_75214_a(itemstack) && this.container.func_94531_b(slot)) {
            this.dragSplittingSlots.add(slot);
            this.updateDragSplitting();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        int i = this.guiLeft;
        int j = this.guiTop;
        boolean flag = this.hasClickedOutside(mouseX, mouseY, i, j);
        if (slot != null) {
            flag = false;
        }
        int k = -1;
        if (slot != null) {
            k = slot.field_75222_d;
        }
        if (flag) {
            k = -999;
        }
        if (this.doubleClick && slot != null && state == 0 && this.container.func_94530_a(ItemStack.field_190927_a, slot)) {
            if (AbstractGUIContainer.func_146272_n()) {
                if (!this.shiftClickedSlot.func_190926_b()) {
                    for (Slot slot2 : this.container.field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g) || !slot2.func_75216_d() || !slot2.isSameInventory(slot) || !Container.func_94527_a((Slot)slot2, (ItemStack)this.shiftClickedSlot, (boolean)true)) continue;
                        this.handleMouseClick(slot2, slot2.field_75222_d, state, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.handleMouseClick(slot, k, state, ClickType.PICKUP_ALL);
            }
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.dragSplitting && this.dragSplittingButton != state) {
                this.dragSplitting = false;
                this.dragSplittingSlots.clear();
                this.ignoreMouseUp = true;
                return;
            }
            if (this.ignoreMouseUp) {
                this.ignoreMouseUp = false;
                return;
            }
            if (this.clickedSlot != null && this.field_146297_k.field_71474_y.field_85185_A) {
                if (state == 0 || state == 1) {
                    if (this.draggedStack.func_190926_b() && slot != this.clickedSlot) {
                        this.draggedStack = this.clickedSlot.func_75211_c();
                    }
                    boolean flag2 = Container.func_94527_a((Slot)slot, (ItemStack)this.draggedStack, (boolean)false);
                    if (k != -1 && !this.draggedStack.func_190926_b() && flag2) {
                        this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                        this.handleMouseClick(slot, k, 0, ClickType.PICKUP);
                        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.returningStack = ItemStack.field_190927_a;
                        } else {
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                            this.touchUpX = mouseX - i;
                            this.touchUpY = mouseY - j;
                            this.returningStackDestSlot = this.clickedSlot;
                            this.returningStack = this.draggedStack;
                            this.returningStackTime = Minecraft.func_71386_F();
                        }
                    } else if (!this.draggedStack.func_190926_b()) {
                        this.touchUpX = mouseX - i;
                        this.touchUpY = mouseY - j;
                        this.returningStackDestSlot = this.clickedSlot;
                        this.returningStack = this.draggedStack;
                        this.returningStackTime = Minecraft.func_71386_F();
                    }
                    this.draggedStack = ItemStack.field_190927_a;
                    this.clickedSlot = null;
                }
            } else if (this.dragSplitting && !this.dragSplittingSlots.isEmpty()) {
                this.handleMouseClick(null, -999, Container.func_94534_d((int)0, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.dragSplittingSlots) {
                    this.handleMouseClick(slot1, slot1.field_75222_d, Container.func_94534_d((int)1, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                }
                this.handleMouseClick(null, -999, Container.func_94534_d((int)2, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
            } else if (!this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(state - 100)) {
                    this.handleMouseClick(slot, k, state, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl = flag1 = k != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                    if (flag1) {
                        this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                    }
                    this.handleMouseClick(slot, k, state, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.lastClickTime = 0L;
        }
        this.dragSplitting = false;
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.isPointInRegion(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        int i = this.guiLeft;
        int j = this.guiTop;
        return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    protected void handleMouseClick(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null) {
            slotId = slotIn.field_75222_d;
        }
        this.field_146297_k.field_71442_b.func_187098_a(this.container.field_75152_c, slotId, mouseButton, type, (EntityPlayer)this.field_146297_k.field_71439_g);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.checkHotbarKeys(keyCode);
        if (this.hoveredSlot != null && this.hoveredSlot.func_75216_d()) {
            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(keyCode)) {
                this.handleMouseClick(this.hoveredSlot, this.hoveredSlot.field_75222_d, 0, ClickType.CLONE);
            } else if (this.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(keyCode)) {
                this.handleMouseClick(this.hoveredSlot, this.hoveredSlot.field_75222_d, AbstractGUIContainer.func_146271_m() ? 1 : 0, ClickType.THROW);
            }
        }
        for (GUISlotsFramework framework : this.getWorkspace().getCurrentSection().getSlotsFrameworks()) {
            framework.keyTyped(typedChar, keyCode);
        }
    }

    protected boolean checkHotbarKeys(int keyCode) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredSlot != null) {
            for (int i = 0; i < 9; ++i) {
                if (!this.field_146297_k.field_71474_y.field_151456_ac[i].isActiveAndMatches(keyCode)) continue;
                this.handleMouseClick(this.hoveredSlot, this.hoveredSlot.field_75222_d, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.field_146297_k.field_71439_g != null) {
            this.container.func_75134_a((EntityPlayer)this.field_146297_k.field_71439_g);
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.isWorkspaceCreated()) {
            for (GUISlotsFramework framework : this.getWorkspace().getCurrentSection().getSlotsFrameworks()) {
                framework.update();
            }
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        return this.hoveredSlot;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }
}

