/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.math;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class IntRange
extends AbstractSet<Integer> {
    private final int start;
    private final int end;

    public IntRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isEmpty() {
        return this.end <= this.start;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    public boolean contains(int n) {
        return n >= this.start && n < this.end;
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<Integer> stream() {
        return IntStream.range(this.start, this.end).boxed();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntRangeIterator(this.start, this.end);
    }

    @Override
    public int size() {
        return Math.max(this.end - this.start, 0);
    }

    @Override
    public String toString() {
        return String.format("%d..%d", this.start, this.end);
    }

    private static class IntRangeIterator
    implements Iterator<Integer> {
        private final int end;
        private int value;

        public IntRangeIterator(int start, int end) {
            this.value = start;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.value < this.end;
        }

        @Override
        public Integer next() {
            if (this.value >= this.end) {
                throw new NoSuchElementException();
            }
            return this.value++;
        }
    }
}

