/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.IMenu;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class DropdownMenu
implements IMenu {
    private int width;
    private int height;
    private int x;
    private int y;
    private List<AdvancedButton> content = new ArrayList<AdvancedButton>();
    private AdvancedButton dropdown;
    private boolean opened = false;
    private boolean hovered = false;
    private boolean autoclose = false;
    private int space;

    public DropdownMenu(String label, int width, int height, int x, int y, int space) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.space = space;
        this.dropdown = new AdvancedButton(0, 0, 0, 0, label, true, press -> this.toggleMenu());
    }

    public void render(int mouseX, int mouseY) {
        float ticks = Minecraft.func_71410_x().func_184121_ak();
        this.updateHovered(mouseX, mouseY);
        this.dropdown.field_146121_g = this.height;
        this.dropdown.field_146120_f = this.width;
        this.dropdown.field_146128_h = this.x;
        this.dropdown.field_146129_i = this.y;
        this.dropdown.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, ticks);
        int stackedHeight = this.height + this.space;
        if (this.opened) {
            for (AdvancedButton b : this.content) {
                b.setHandleClick(true);
                b.field_146120_f = this.width;
                b.field_146128_h = this.x;
                b.field_146129_i = this.y + stackedHeight;
                b.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, ticks);
                stackedHeight += b.field_146121_g + this.space;
            }
        }
        if (this.autoclose && !this.isHovered() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
            this.opened = false;
        }
    }

    private void updateHovered(int mouseX, int mouseY) {
        if (mouseX >= this.dropdown.field_146128_h && mouseX <= this.dropdown.field_146128_h + this.dropdown.field_146120_f && mouseY >= this.dropdown.field_146129_i && mouseY <= this.dropdown.field_146129_i + this.dropdown.field_146121_g) {
            this.hovered = true;
            return;
        }
        for (AdvancedButton b : this.content) {
            if (mouseX < b.field_146128_h || mouseX > b.field_146128_h + b.field_146120_f || mouseY < b.field_146129_i || mouseY > b.field_146129_i + b.field_146121_g) continue;
            this.hovered = true;
            return;
        }
        this.hovered = false;
    }

    public boolean isHovered() {
        if (!this.isOpen()) {
            return false;
        }
        return this.hovered;
    }

    @Override
    public void setUseable(boolean b) {
        this.dropdown.setUseable(b);
        for (AdvancedButton bt : this.content) {
            bt.setUseable(b);
        }
        if (!b) {
            this.opened = false;
        }
    }

    @Override
    public boolean isUseable() {
        if (this.dropdown == null) {
            return false;
        }
        return this.dropdown.isUseable();
    }

    public void setAutoclose(boolean b) {
        this.autoclose = b;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    public void openMenu() {
        this.opened = true;
    }

    @Override
    public void closeMenu() {
        this.opened = false;
    }

    private void toggleMenu() {
        this.opened = !this.opened;
    }

    public void addContent(AdvancedButton button) {
        this.content.add(button);
    }

    public void setLabel(String text) {
        this.dropdown.field_146126_j = text;
    }

    public AdvancedButton getDropdownParent() {
        return this.dropdown;
    }
}

