/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.core.utils.TopDownBlockPosComparator;
import forestry.farming.FarmTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmHelper {
    public static final ImmutableSet<Block> bricks = ImmutableSet.of((Object)Blocks.field_150336_V, (Object)Blocks.field_150417_aV, (Object)Blocks.field_150322_A, (Object)Blocks.field_150385_bj, (Object)Blocks.field_150371_ca);

    private static FarmDirection getLayoutDirection(FarmDirection farmSide) {
        switch (farmSide) {
            case NORTH: {
                return FarmDirection.WEST;
            }
            case WEST: {
                return FarmDirection.SOUTH;
            }
            case SOUTH: {
                return FarmDirection.EAST;
            }
            case EAST: {
                return FarmDirection.NORTH;
            }
        }
        return null;
    }

    private static FarmDirection getOpposite(FarmDirection farmDirection) {
        EnumFacing forgeDirection = farmDirection.getFacing();
        EnumFacing forgeDirectionOpposite = forgeDirection.func_176734_d();
        return FarmDirection.getFarmDirection(forgeDirectionOpposite);
    }

    private static BlockPos getFarmMultiblockCorner(BlockPos start, FarmDirection farmSide, FarmDirection layoutDirection, BlockPos minFarmCoord, BlockPos maxFarmCoord) {
        BlockPos edge = FarmHelper.getFarmMultiblockEdge(start, farmSide, maxFarmCoord, minFarmCoord);
        return FarmHelper.getFarmMultiblockEdge(edge, FarmHelper.getOpposite(layoutDirection), maxFarmCoord, minFarmCoord);
    }

    private static BlockPos getFarmMultiblockEdge(BlockPos start, FarmDirection direction, BlockPos maxFarmCoord, BlockPos minFarmCoord) {
        switch (direction) {
            case NORTH: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o(), minFarmCoord.func_177952_p());
            }
            case EAST: {
                return new BlockPos(maxFarmCoord.func_177958_n(), start.func_177956_o(), start.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o(), maxFarmCoord.func_177952_p());
            }
            case WEST: {
                return new BlockPos(minFarmCoord.func_177958_n(), start.func_177956_o(), start.func_177952_p());
            }
        }
        throw new IllegalArgumentException("Invalid farm direction: " + (Object)((Object)direction));
    }

    public static void createTargets(World world, IFarmHousing farmHousing, Map<FarmDirection, List<FarmTarget>> targets, BlockPos targetStart, int allowedExtent, int farmSizeNorthSouth, int farmSizeEastWest, BlockPos minFarmCoord, BlockPos maxFarmCoord) {
        for (FarmDirection farmSide : FarmDirection.values()) {
            BlockPos groundLocation;
            int farmWidth = farmSide == FarmDirection.NORTH || farmSide == FarmDirection.SOUTH ? farmSizeEastWest : farmSizeNorthSouth;
            int targetMaxLimit = allowedExtent + farmWidth;
            FarmDirection layoutDirection = FarmHelper.getLayoutDirection(farmSide);
            ArrayList<FarmTarget> farmSideTargets = new ArrayList<FarmTarget>();
            targets.put(farmSide, farmSideTargets);
            BlockPos targetLocation = FarmHelper.getFarmMultiblockCorner(targetStart, farmSide, layoutDirection, minFarmCoord, maxFarmCoord);
            BlockPos firstLocation = targetLocation.func_177972_a(farmSide.getFacing());
            BlockPos firstGroundPosition = FarmHelper.getGroundPosition(world, farmHousing, firstLocation);
            if (firstGroundPosition == null) continue;
            int groundHeight = firstGroundPosition.func_177956_o();
            for (int i = 0; i < allowedExtent && world.func_175667_e(groundLocation = new BlockPos((targetLocation = targetLocation.func_177972_a(farmSide.getFacing())).func_177958_n(), groundHeight, targetLocation.func_177952_p())) && farmHousing.isValidPlatform(world, groundLocation); ++i) {
                int targetLimit = targetMaxLimit;
                if (!farmHousing.isSquare()) {
                    targetLimit = targetMaxLimit - i - 1;
                }
                FarmTarget target = new FarmTarget(targetLocation, layoutDirection, targetLimit);
                farmSideTargets.add(target);
            }
        }
    }

    @Nullable
    private static BlockPos getGroundPosition(World world, IFarmHousing farmHousing, BlockPos targetPosition) {
        if (!world.func_175667_e(targetPosition)) {
            return null;
        }
        for (int yOffset = 2; yOffset > -4; --yOffset) {
            BlockPos position = targetPosition.func_177982_a(0, yOffset, 0);
            if (!world.func_175667_e(position) || !farmHousing.isValidPlatform(world, position)) continue;
            return position;
        }
        return null;
    }

    public static boolean isCycleCanceledByListeners(IFarmLogic logic, FarmDirection direction, Iterable<IFarmListener> farmListeners) {
        for (IFarmListener listener : farmListeners) {
            if (!listener.cancelTask(logic, direction)) continue;
            return true;
        }
        return false;
    }

    public static void setExtents(World world, IFarmHousing farmHousing, Map<FarmDirection, List<FarmTarget>> targets) {
        for (List<FarmTarget> targetsList : targets.values()) {
            if (targetsList.isEmpty()) continue;
            BlockPos groundPosition = FarmHelper.getGroundPosition(world, farmHousing, targetsList.get(0).getStart());
            for (FarmTarget target : targetsList) {
                target.setExtentAndYOffset(world, groundPosition, farmHousing);
            }
        }
    }

    public static boolean cultivateTarget(World world, IFarmHousing farmHousing, FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        BlockPos targetPosition = target.getStart().func_177982_a(0, target.getYOffset(), 0);
        if (logic.cultivate(world, farmHousing, targetPosition, target.getDirection(), target.getExtent())) {
            for (IFarmListener listener : farmListeners) {
                listener.hasCultivated(logic, targetPosition, target.getDirection(), target.getExtent());
            }
            return true;
        }
        return false;
    }

    public static Collection<ICrop> harvestTargets(World world, List<FarmTarget> farmTargets, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        for (FarmTarget target : farmTargets) {
            Collection<ICrop> harvested = FarmHelper.harvestTarget(world, target, logic, farmListeners);
            if (harvested.isEmpty()) continue;
            return harvested;
        }
        return Collections.emptyList();
    }

    public static Collection<ICrop> harvestTarget(World world, FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        BlockPos pos = target.getStart().func_177982_a(0, target.getYOffset(), 0);
        Collection<ICrop> harvested = logic.harvest(world, pos, target.getDirection(), target.getExtent());
        if (!harvested.isEmpty()) {
            for (IFarmListener listener : farmListeners) {
                listener.hasScheduledHarvest(harvested, logic, pos, target.getDirection(), target.getExtent());
            }
        }
        return harvested;
    }

    public static class TopDownICropComparator
    implements Comparator<ICrop> {
        public static final TopDownICropComparator INSTANCE = new TopDownICropComparator();

        private TopDownICropComparator() {
        }

        @Override
        public int compare(ICrop o1, ICrop o2) {
            return TopDownBlockPosComparator.INSTANCE.compare(o1.getPosition(), o2.getPosition());
        }
    }

    public static class FarmWorkStatus {
        public boolean didWork = false;
        public boolean hasFarmland = false;
        public boolean hasFertilizer = true;
        public boolean hasLiquid = true;
    }

    public static enum Stage {
        CULTIVATE,
        HARVEST;


        public Stage next() {
            if (this == CULTIVATE) {
                return HARVEST;
            }
            return CULTIVATE;
        }
    }
}

