/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeModelProvider;
import forestry.api.core.IModelManager;
import forestry.apiculture.items.ItemBeeGE;
import java.util.EnumMap;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DefaultBeeModelProvider
implements IBeeModelProvider {
    public static final DefaultBeeModelProvider instance = new DefaultBeeModelProvider();
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private static EnumMap<EnumBeeType, ModelResourceLocation> models;

    private DefaultBeeModelProvider() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager) {
        String beeIconDir = "bees/default/";
        EnumBeeType beeType = ((ItemBeeGE)item).getType();
        String beeTypeNameBase = beeIconDir + beeType.toString().toLowerCase(Locale.ENGLISH);
        if (models == null) {
            models = new EnumMap(EnumBeeType.class);
        }
        models.put(beeType, manager.getModelLocation(beeTypeNameBase));
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:" + beeTypeNameBase)});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(EnumBeeType type) {
        return models.get(type);
    }
}

