/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenShrub {

    public static class Shrub
    extends WorldGenArboriculture {
        private static final int minHeight = 1;
        private static final int maxHeight = 10;
        protected int girth;
        protected int height;

        public Shrub(ITreeGenData tree) {
            super(tree);
        }

        public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
            WorldGenHelper.generateTreeTrunk((World)world, (Random)rand, (ITreeBlockType)wood, (BlockPos)startPos, (int)this.height, (int)this.girth, (int)0, (float)0.0f, null, (float)0.0f);
            return Collections.emptySet();
        }

        protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
            float leafSpawn;
            float f = leafSpawn = (float)this.height;
            leafSpawn = f - 1.0f;
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177963_a(0.0, (double)f, 0.0), (int)this.girth, (float)this.girth, (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177963_a(0.0, (double)f2, 0.0), (int)this.girth, (float)((float)this.girth + 1.0f), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
            int i = 0;
            while (leafSpawn >= 0.0f) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                WorldGenHelper.generateCylinderFromTreeStartPos((World)world, (ITreeBlockType)leaf, (BlockPos)startPos.func_177963_a(0.0, (double)f3, 0.0), (int)this.girth, (float)((float)this.girth + 2.0f + (float)i), (int)1, (WorldGenHelper.EnumReplaceMode)WorldGenHelper.EnumReplaceMode.SOFT);
                ++i;
            }
        }

        protected void generateExtras(World world, Random rand, BlockPos startPos) {
        }

        @Nullable
        public BlockPos getValidGrowthPos(World world, BlockPos pos) {
            return this.tree.canGrow(world, pos, this.girth, this.height);
        }

        public final void preGenerate(World world, Random rand, BlockPos startPos) {
            super.preGenerate(world, rand, startPos);
            this.height = this.determineHeight(world, rand, 1, 1);
            this.girth = this.tree.getGirth();
        }

        private int determineHeight(World world, Random rand, int required, int variation) {
            ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
            int baseHeight = required + rand.nextInt(variation);
            int height = Math.round((float)baseHeight * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
            return height < 1 ? 1 : Math.min(height, 10);
        }
    }
}

