/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.frame;

import binnie.core.machines.Machine;
import binnie.extrabees.machines.TileExtraBeeAlveary;
import binnie.extrabees.utils.ComponentBeeModifier;
import binnie.extrabees.utils.Utils;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.multiblock.IAlvearyController;
import forestry.api.multiblock.IMultiblockLogicAlveary;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ComponentFrameModifier
extends ComponentBeeModifier
implements IBeeModifier,
IBeeListener {
    public ComponentFrameModifier(Machine machine) {
        super(machine);
    }

    @Override
    public void wearOutEquipment(int amount) {
        IHiveFrame hiveFrame = this.getHiveFrame();
        if (hiveFrame != null) {
            IMultiblockLogicAlveary multiblockLogic;
            IAlvearyController alvearyController;
            ItemStack queenStack;
            World world = this.getMachine().getTileEntity().func_145831_w();
            IBeeRoot beeRoot = Utils.getBeeRoot();
            IBee queen = beeRoot.getMember(queenStack = (alvearyController = (multiblockLogic = ((TileExtraBeeAlveary)this.getMachine().getTileEntity()).getMultiblockLogic()).getController()).getBeeInventory().getQueen());
            if (queen != null) {
                int wear = Math.round((float)(amount * 5) * beeRoot.getBeekeepingMode(world).getWearModifier());
                ItemStack frame = this.getInventory().func_70301_a(0);
                ItemStack frameUsed = hiveFrame.frameUsed((IBeeHousing)alvearyController, frame, queen, wear);
                this.getInventory().func_70299_a(0, frameUsed);
            }
        }
    }

    @Nullable
    public IHiveFrame getHiveFrame() {
        ItemStack stackInSlot = this.getInventory().func_70301_a(0);
        if (!stackInSlot.func_190926_b()) {
            return (IHiveFrame)stackInSlot.func_77973_b();
        }
        return null;
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getTerritoryModifier(genome, currentModifier);
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getMutationModifier(genome, mate, currentModifier);
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getLifespanModifier(genome, mate, currentModifier);
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getProductionModifier(genome, currentModifier);
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getFloweringModifier(genome, currentModifier);
    }
}

